/* vputn.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

void v_putn (char c, int count)
{
  if (count > 0)
    {
#if defined (IF_OS2)
      IF_OS2
        {
          BYTE cell[2];

          cell[0] = c;
          cell[1] = (BYTE)_v_attr;
          VioWrtNCell (cell, (USHORT)count, (USHORT)_v_y, (USHORT)_v_x, 0);
        }
#endif
#if defined (IF_DOS)
      IF_DOS
        {
          if (_v_mem != NULL)
            {
              char *p;

              p = _v_mem + (_v_y * _v_width + _v_x) * 2;
              while (count > 0)
                {
                  p[0] = c;
                  p[1] = (char)_v_attr;
                  --count; p += 2;
                }
            }
          else
            {
              union REGS r;

              r.h.ah = 0x09;
              r.h.bh = 0;
              r.h.bl = (unsigned char)_v_attr;
              r.h.al = c;
              r.x.cx = count;
              _int86 (0x10, &r, &r);
            }
        }
#endif
    }
}
