/* vglline.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include "graph2.h"

void _vgl_line (int x0, int y0, int x1, int y1, int color)
{
  if (_gline_clip (x0, y0, &x1, &y1) && _gline_clip (x1, y1, &x0, &y0))
    {
      int dx, dy, temp, iy, n, e;
      unsigned char *p;

      dx = x1 - x0;
      if (dx < 0)
        {
          dx = -dx;
          temp = x1; x1 = x0; x0 = temp;
          temp = y1; y1 = y0; y0 = temp;
        }
      ++dx;
      dy = y1 - y0; iy = 320;
      if (dy < 0)
        {
          dy = -dy;
          iy = -iy;
        }
      ++dy;
      GLOCK;
      p = _g_mem + x0 + 320 * y0;
      if (dx >= dy)
        {
          n = dx; e = dy / 2;
          do
            {
              *p = (unsigned char)color;
              ++p;
              e += dy;
              if (e >= dx)
                {
                  e -= dx;
                  p += iy;
                }
            } while (--n != 0);
        }
      else
        {
          n = dy; e = dx / 2;
          do
            {
              *p = (unsigned char)color;
              p += iy;
              e += dx;
              if (e >= dy)
                {
                  e -= dy;
                  ++p;
                }
            } while (--n != 0);
        }
      GUNLOCK;
    }
}
