#include <stdio.h>
#include <stdlib.h>

#define INCL_WIN

#include "menudemo.h"
#include "menu.h"

void PopupMenu(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2) {
	HWND		hwndMenu;
	POINTL		Mouse;

// Nytetn menu vain, jos ikkuna on fullscreen.
	if (fullscreen) {

// Kun ikkuna on fullscreenin, on menun isnt HWND_OBJECT.
		hwndMenu = WinWindowFromID(
					HWND_OBJECT,
					FID_MENU);		// Vakio, jonka kytt 
									// vaatii alussa olevaa INCL_WIN:

// Menu ilmestyy hiirikursorin kohdalle. Haetaan hiiren koordinaatit.
// (mp1 ja mp2 ovat 32-bittisi lukuja. SHORTxFROMMP:ll voidaan
// hakea kaksi 16-bittist lukua. 
 
		Mouse.x = (LONG)SHORT1FROMMP(mp1);
		Mouse.y = (LONG)SHORT2FROMMP(mp1);
	
		WinPopupMenu(
			hwnd,		// Parent.
			hwnd,		// Owner.  Kytnnss se ikkuna, joka
						// vastaanottaa menusta tulevat viestit.
			hwndMenu,
			Mouse.x,
			Mouse.y,
			NULLHANDLE,	// menukohta, joka valitaan valmiiksi
			PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2);
			// valinta voidaan tehd hiiren nappuloilla 1 tai 2.

			// Toiseksiviimeisen parametrin kyttmist varten
			// on viimeiseen kohtaan listtv PU_SELECTITEM.
	}
};


MRESULT ClientWndProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2) {
	switch(msg) {

// Ksitelln menusta tulevat viestit
		case WM_COMMAND:
			switch(SHORT1FROMMP(mp1)) {

			// Kaikki menun toiminnot on omassa funktiossaan
			// Menu_***. Ne on menufunc.c:ss.
				case IDM_FILEOPEN:
					Menu_FileOpen(hwnd, msg, mp1, mp2);
					break;
				case IDM_SAVE:
					Menu_FileSave(hwnd, msg, mp1, mp2);
					break;
			// Jos saveas on disabloitu, jtt kyttis
			// itsestn IDM_SAVEAS-viestin lhettmtt
				case IDM_SAVEAS:
					Menu_FileSaveAs(hwnd, msg, mp1, mp2);
					break;
				case IDM_QUIT:
					Menu_Quit(hwnd, msg, mp1, mp2);
					break;
				case IDM_ENABLSAVE:
					Menu_EnaSa(hwnd, msg, mp1, mp2);
					break;
				case IDM_MINMAX:
					Menu_MinMax(hwnd, msg, mp1, mp2);
					break;
				case IDM_FULLSCREEN:
					Menu_FullScreen(hwnd, msg, mp1, mp2);
					break;
			}	

// Ikkunan maalaamista varten tehdn presentation space (ClientHps).
// Piirtminen tapahtuu aina PS:n. 
		case WM_CREATE:{
			HDC	hdc;
			SIZEL	koko;

			koko.cx=0L;		
			koko.cy=0L;

			hdc=WinOpenWindowDC(hwnd);

			ClientHps=GpiCreatePS(
						hab,	
						hdc,	
						&koko,		
						PU_PELS | 
						GPIF_DEFAULT |
						GPIT_MICRO |
						GPIA_ASSOC);

			return(0);
		}

		case WM_PAINT:{
			GpiErase(ClientHps);
			break;
		}

		case WM_CONTEXTMENU:
			PopupMenu(hwnd, msg, mp1, mp2);
			return(0);
	}
	return(WinDefWindowProc(hwnd,msg,mp1,mp2));
}
