#include <stdio.h>
#include <stdlib.h>

// Ilman seuraavaa rivi kyttjrjestelmn vakiot (esim. FID_MENU)
// ei toimi.
#define INCL_WIN

#include "menudemo.h"
#include "menu.h"

void Menu_FileOpen(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
// Avattava fileopen dialogi on standardi, eik sit olla erikseen
// suunniteltu resurssitiedostossa. Samalla tavalla avataan mys 
// saveas-dialogi. FILEDLG tarvitsee alussa olevaa INCL_WIN rivi.

	FILEDLG	fild;

	memset(&fild, 0, sizeof(FILEDLG));
	fild.cbSize=sizeof(FILEDLG);
	fild.fl=FDS_OPEN_DIALOG | FDS_CENTER ;
	fild.pszIDrive="c:";
	WinFileDlg(HWND_DESKTOP,hwnd,&fild);

// Valitun tiedoston koko nimi polkuineen on muuttujassa
// fild.szFullFile.

}

void Menu_FileSave(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	DosBeep(1000,50);
}

void Menu_FileSaveAs(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	FILEDLG	fild;

	memset(&fild, 0, sizeof(FILEDLG));
	fild.cbSize=sizeof(FILEDLG);
	fild.fl=FDS_SAVEAS_DIALOG | FDS_CENTER ;
	fild.pszIDrive="c:";
	WinFileDlg(HWND_DESKTOP,hwnd,&fild);
}

void Menu_Quit(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
// Lopetetaan ohjelma, lhetetn ikkunalle WM_QUIT-viesti.
// Kaksi viimeist parametri on viestin parametrit, joita ei tarvita.

	WinPostMsg(hwnd, WM_QUIT, NULLHANDLE, NULLHANDLE);
}

// Seuraava funktio Enabloi / Disabloi menun file/saveas kohdan
void Menu_EnaSa(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	HWND	hwndFrame;
	HWND	hwndMenu;
	USHORT	Attr;
	MRESULT	Reply;
	CHAR	Text[64];
	ULONG	ulStyle;

// Haetaan frame ja menu.
	hwndFrame = WinQueryWindow(hwnd, QW_PARENT);

// Jos ikkuna on fullscreeniss, on menun isnt HWND_OBJECT,
// muuten se on hwndFrame.
	if (fullscreen) hwndMenu = WinWindowFromID(HWND_OBJECT, FID_MENU);
	else hwndMenu = WinWindowFromID(hwndFrame, FID_MENU);

// Lhetetn menulle MM_QUERYITEMATTR (Query = tiedustella),
// eli tm viesti tiedustelee menun attribuutteja. Tulos
// tallennetaan Reply-muuttujaan.

	Reply = WinSendMsg(
		hwndMenu,
		MM_QUERYITEMATTR,
		MPFROM2SHORT(IDM_SAVEAS, TRUE),
		MPFROMSHORT(MIA_DISABLED));
	Attr = SHORT1FROMMR(Reply);

// Oliko attribuuteissa MIA_DISABLED bitti pll?. Kopioidaan
// sen mukaisesti uusi teksti text-muuttujaan, joka myhemmin
// siirretn menuun.
	if (Attr && MIA_DISABLED)
		strcpy(Text, "Disable save");
	else
		strcpy(Text, "Enable save");

// Knnetn MIA_DISABLED-bitti
	Attr ^= MIA_DISABLED;

// Lhetetn menulle MM_SETITEMATTR, ja uudet attribuutit.
	WinSendMsg(
		hwndMenu,
		MM_SETITEMATTR,
		MPFROM2SHORT(IDM_SAVEAS, TRUE),
		MPFROM2SHORT(MIA_DISABLED, Attr));

// Vaihdetaan viel teksti muuttujan text mukaiseksi.
	WinSendMsg(	
		hwndMenu, 
		MM_SETITEMTEXT, 
		MPFROMSHORT(IDM_ENABLSAVE),
		MPFROMP(Text));
}

void Menu_MinMax(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	HWND	hwndFrame;
	ULONG	Style;

	hwndFrame = WinQueryWindow(hwnd, QW_PARENT);

	Style = WinQueryWindowULong(
		hwndFrame,
		QWL_STYLE);

// Onko ikkunan maksimoitu?
	if (Style & WS_MAXIMIZED) {

// Ikkuna on maksimoitu, palautetaan se takaisin
		WinSetWindowPos(
			hwndFrame,
			HWND_TOP,
			10, 10, 400, 400,
			SWP_RESTORE | // tm poistaa maksimoinnin
			SWP_SHOW |  
			SWP_ACTIVATE);
	}
	else {

// Ikkunaa ei oltu maksimoitu, tehdn se.
		WinSetWindowPos(
			hwndFrame,
			HWND_TOP,
			10, 10, 400, 400,
			SWP_MAXIMIZE | // tm maksimoi
			SWP_SHOW |  
			SWP_ACTIVATE);
	}
}

void Menu_FullScreen(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	static	HWND	hwndTitlebar;
	static	HWND	hwndSysMenu;
	static	HWND	hwndAppMenu;
	static	HWND	hwndMinMax;
	HWND			hwndFrame;
	static	ULONG	MenuStyle;

	hwndFrame = WinQueryWindow(hwnd, QW_PARENT);

	if (!fullscreen) {
// Piilotetaan otsikkopalkki, menu, sys-menu ja minmax-napit
// vaihtamalla niiden isnnksi HWND_OBJECT. Haetaan ensin ko.
// ikkunoiden HWND-muuttujat.
		hwndTitlebar	= WinWindowFromID(hwndFrame, FID_TITLEBAR);
		hwndSysMenu		= WinWindowFromID(hwndFrame, FID_SYSMENU);
		hwndAppMenu		= WinWindowFromID(hwndFrame, FID_MENU);
		hwndMinMax		= WinWindowFromID(hwndFrame, FID_MINMAX);

// Kun menu palautetaan taas nkyviin, on se edelleen popup-muotoinen
// (pystyss). Otetaan talteen menun tyyli.
		MenuStyle = WinQueryWindowULong(
			hwndAppMenu,
			QWL_STYLE);

// Vaihdetaan ikkunoiden isnt (siis parentia)
		WinSetParent(hwndTitlebar, HWND_OBJECT, FALSE);
		WinSetParent(hwndSysMenu, HWND_OBJECT, FALSE);
		WinSetParent(hwndAppMenu, HWND_OBJECT, FALSE);
		WinSetParent(hwndMinMax, HWND_OBJECT, FALSE);

		WinSetWindowPos(
			hwndFrame,
			HWND_TOP,
			0, 0, 0, 0,
			SWP_MAXIMIZE | // maksimointi
			SWP_SHOW |  
			SWP_ACTIVATE);

// Vaihdetaan menun teksti
		WinSendMsg(	
			hwndAppMenu, 
			MM_SETITEMTEXT, 
			MPFROMSHORT(IDM_FULLSCREEN),
			MPFROMP("Windowed"));

// Lhetetn ksky pivitt koko roska.
		WinSendMsg(
			hwndFrame, 
			WM_UPDATEFRAME,
			(MPARAM)(FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX | FCF_MENU),
			NULL);
		fullscreen = TRUE;
	}
	else {
// Palautetaan kaikki nkyviin vaihtamalla isnnksi taas hwndFrame.
		WinSetParent(hwndTitlebar, hwndFrame, FALSE);
		WinSetParent(hwndSysMenu, hwndFrame, FALSE);
		WinSetParent(hwndAppMenu, hwndFrame, FALSE);
		WinSetParent(hwndMinMax, hwndFrame, FALSE);

// Palautetaan tyyli, joka otettiin talteen maksimoinnissa.
// (kokeile ottaa ksky pois)
		WinSetWindowULong(
			hwndAppMenu,
			QWL_STYLE,
			MenuStyle);

		WinSetWindowPos(
			hwndFrame,
			HWND_TOP,
			0, 0, 0, 0,
			SWP_RESTORE | // ei-maksimoiduksi
			SWP_SHOW |  
			SWP_ACTIVATE);

		WinSendMsg(	
			hwndAppMenu, 
			MM_SETITEMTEXT, 
			MPFROMSHORT(IDM_FULLSCREEN),
			MPFROMP("FullScreen"));

		WinSendMsg(
			hwndFrame, 
			WM_UPDATEFRAME,
			(MPARAM)(FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX | FCF_MENU),
			NULL);

		fullscreen = FALSE;
	}
}
