/* test2.c */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <db.h>

struct key
{
  char name[16];
};

struct rec
{
  int n;
};


static void add (DB *db, char *k, int d)
{
  struct rec data;
  struct key key;
  DBT dbt_key, dbt_data;

  memset (&key, 0, sizeof (key));
  strcpy (key.name, k);
  data.n = d;
  dbt_key.data = &key; dbt_key.size = sizeof (key);
  dbt_data.data = &data; dbt_data.size = sizeof (data);
  if (db->put (db, &dbt_key, &dbt_data, 0) != 0)
    {
      perror ("db->put()");
      exit (2);
    }
}


static int seq (DB *db, int flags)
{
  DBT dbt_key, dbt_data;
  int rc;

  memset (&dbt_key, 0, sizeof (dbt_key));
  memset (&dbt_data, 0, sizeof (dbt_data));

  rc = db->seq (db, &dbt_key, &dbt_data, flags);
  if (rc < 0)
    {
      perror ("db->seq()");
      exit (2);
    }

  if (rc > 0)
    return (0);

  printf ("%s -> %d\n",
          ((struct key *)dbt_key.data)->name,
          ((struct rec *)dbt_data.data)->n);
  return (1);
}


int my_compare (const DBT *key1, const DBT *key2)
{
  return (strcmp (((struct key *)key1->data)->name,
                  ((struct key *)key2->data)->name));
}


int main (int argc, char *argv[])
{
  BTREEINFO info;
  DB *db;
  int i;

  info.flags = 0;
  info.cachesize = 0;
  info.psize = 0;
  info.lorder = 0;
  info.minkeypage = 0;
  info.compare = my_compare;
  info.prefix = NULL;

  db = dbopen ("test2.dat", O_CREAT | O_RDWR, S_IREAD | S_IWRITE, DB_BTREE,
               &info);
  if (db == NULL)
    {
      perror ("dbopen()");
      exit (2);
    }

  add (db, "five", 5);
  add (db, "two", 2);
  add (db, "three", 3);
  add (db, "one", 1);
  add (db, "four", 4);
  add (db, "seven", 7);

  if (seq (db, R_FIRST))
    while (seq (db, R_NEXT))
      ;

  if (db->close (db) != 0)
    {
      perror ("db->close()");
      exit (2);
    }
  return (0);
}
