/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class BooleanFormat
extends Format {
    static int TRUESTR = 0;
    static int FALSESTR = 1;
    static int NULLSTR = 2;
    private String pattern;
    private String[] strings = new String[3];

    public BooleanFormat() {
        this.applyPattern(null);
    }

    public BooleanFormat(String string) {
        this();
        this.applyPattern(string);
    }

    public void applyPattern(String string) {
        if (string == null || string.length() == 0) {
            string = "true;false";
        }
        this.pattern = string;
        this.decomposePattern();
    }

    public String toPattern() {
        return this.pattern == null ? null : this.pattern;
    }

    private void decomposePattern() {
        this.strings[2] = "";
        this.strings[1] = "";
        this.strings[0] = "";
        if (this.pattern == null || this.pattern.length() == 0) {
            return;
        }
        String string = this.pattern;
        for (int i = 0; i < this.strings.length; ++i) {
            int n = string.indexOf(";");
            if (n < 0) {
                n = string.length();
            }
            if (n > 0) {
                this.strings[i] = string.substring(0, n).trim();
            }
            if (n >= string.length()) break;
            string = string.substring(n + 1, string.length());
        }
    }

    public StringBuffer format(Boolean bl, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        int n2 = bl == null ? NULLSTR : (n = bl != false ? TRUESTR : FALSESTR);
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.append(this.strings[n]);
        return stringBuffer;
    }

    public Boolean parse(String string, ParsePosition parsePosition) {
        if (string == null) {
            return null;
        }
        int n = parsePosition.getIndex();
        String string2 = string.substring(n);
        int n2 = string2.length();
        parsePosition.setIndex(n + n2);
        if (n2 == 0) {
            return null;
        }
        char[] cArray = new char[n2];
        string2.getChars(0, n2, cArray, 0);
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] != '_') continue;
            cArray[i] = 32;
        }
        string2 = new String(cArray);
        n2 = (string2 = string2.trim()).length();
        if (n2 == 0) {
            return null;
        }
        if (string2.equalsIgnoreCase(this.strings[TRUESTR])) {
            return new Boolean(true);
        }
        if (string2.equalsIgnoreCase(this.strings[FALSESTR])) {
            return new Boolean(false);
        }
        if (string2.equalsIgnoreCase(this.strings[NULLSTR])) {
            return null;
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (n2 <= this.strings[TRUESTR].length()) {
            string3 = this.strings[TRUESTR].substring(0, string2.length());
        }
        if (n2 <= this.strings[FALSESTR].length()) {
            string4 = this.strings[FALSESTR].substring(0, string2.length());
        }
        if (n2 <= this.strings[NULLSTR].length()) {
            string5 = this.strings[NULLSTR].substring(0, string2.length());
        }
        boolean bl = string2.equalsIgnoreCase(string3);
        boolean bl2 = string2.equalsIgnoreCase(string4);
        boolean bl3 = string2.equalsIgnoreCase(string5);
        if (bl && !bl2 && !bl3) {
            return new Boolean(true);
        }
        if (bl2 && !bl && !bl3) {
            return new Boolean(false);
        }
        if (bl3 && !bl && !bl2) {
            return null;
        }
        parsePosition.setIndex(n);
        return null;
    }

    public final Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(object.toString(), stringBuffer, fieldPosition);
    }

    public String getTrueString() {
        return this.strings[TRUESTR];
    }

    public String getFalseString() {
        return this.strings[FALSESTR];
    }

    public String getNullString() {
        return this.strings[NULLSTR];
    }
}

