/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import COM.objectspace.jgl.Array;
import borland.jbcl.control.PlaceHolder;
import borland.jbcl.model.BasicVectorContainer;
import borland.jbcl.model.BasicViewManager;
import borland.jbcl.model.VectorModelEvent;
import borland.jbcl.model.VectorSelectionEvent;
import borland.jbcl.view.FocusableItemPainter;
import borland.jbcl.view.TabsetView;
import borland.jbcl.view.TextItemPainter;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;

public class TabsetPanel
extends TabsetView {
    private Array pageInfo = new Array();
    CardLayout cardLayout = new CardLayout();
    Insets margins = new Insets(4, 4, 4, 4);

    public TabsetPanel() {
        super.setModel(new BasicVectorContainer());
        TextItemPainter textItemPainter = new TextItemPainter(33, new Insets(1, 1, 1, 1));
        super.setViewManager(new BasicViewManager(new FocusableItemPainter(textItemPainter)));
        this.setClientBordered(true);
        super.setLayout(this.cardLayout);
        super.addImpl(new Panel(), "BLANK", -1);
    }

    public void setSelectedPage(Component component) {
        int n = this.pageInfo.indexOf(component);
        if (n != -1) {
            this.setSelectedIndex(n);
        }
    }

    public Component getSelectedPage() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        Component component = (Component)this.pageInfo.at(n);
        if (component instanceof PlaceHolder) {
            return null;
        }
        return component;
    }

    public void removePage(Component component) {
        int n = this.pageInfo.indexOf(component);
        if (n != -1) {
            this.removeTab((String)this.model.get(n));
        }
    }

    public void setLabels(String[] stringArray) {
        super.setLabels(stringArray);
    }

    public void addTab(Object object) {
        super.addTab(object);
    }

    public void removeTab(String string) {
        if (this.isReadOnly()) {
            return;
        }
        int n = this.writeModel.find(string);
        if (n != -1) {
            Component component = (Component)this.pageInfo.at(n);
            this.pageInfo.remove(n);
            if (!(component instanceof PlaceHolder)) {
                super.remove(component);
            }
            super.removeTab(string);
        }
    }

    public void addTab(int n, String string) {
        if (this.isReadOnly()) {
            return;
        }
        if (n != -1) {
            this.pageInfo.insert(n, null);
        }
        super.addTab(n, string);
    }

    public void addImpl(Component component, Object object, int n) {
        this.writeModel.enableModelEvents(false);
        if (object != null) {
            int n2 = this.model.find(object);
            if (n2 != -1) {
                Component component2 = (Component)this.pageInfo.at(n2);
                if (!(component2 instanceof PlaceHolder)) {
                    super.remove(component2);
                }
                this.pageInfo.put(n2, component);
            } else {
                this.pageInfo.add(component);
                super.addTab(object);
            }
        } else {
            this.pageInfo.add(component);
            object = component.getName();
            super.addTab(object);
        }
        super.addImpl(component, object, n);
        this.writeModel.enableModelEvents(true);
        String string = this.getSelectedTab();
        if (string != null && string.equals((String)object)) {
            this.cardLayout.show(this, string);
        }
    }

    public void remove(Component component) {
        int n = this.pageInfo.indexOf(component);
        if (n != -1) {
            this.pageInfo.put(n, new PlaceHolder());
        }
        super.remove(component);
    }

    public void removeAll() {
        if (this.isReadOnly()) {
            return;
        }
        for (int i = 0; i < this.pageInfo.size(); ++i) {
            if (this.pageInfo.at(i) instanceof PlaceHolder) continue;
            super.remove((Component)this.pageInfo.at(i));
        }
        this.pageInfo.clear();
        this.writeModel.removeAll();
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.left += this.margins.left;
        insets.top += this.margins.top;
        insets.right += this.margins.right;
        insets.bottom += this.margins.bottom;
        return insets;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets insets) {
        this.margins = insets == null ? new Insets(0, 0, 0, 0) : insets;
        this.invalidate();
        this.repaint(100L);
    }

    public void selectionChanged(VectorSelectionEvent vectorSelectionEvent) {
        super.selectionChanged(vectorSelectionEvent);
        int n = this.getSelectedIndex();
        if (n != -1 && !(this.pageInfo.at(n) instanceof PlaceHolder)) {
            String string = this.model.get(n).toString();
            this.cardLayout.show(this, string);
            return;
        }
        this.cardLayout.show(this, "BLANK");
    }

    public void modelContentChanged(VectorModelEvent vectorModelEvent) {
        switch (vectorModelEvent.getChange()) {
            case 1: 
            case 17: 
            case 33: {
                this.updateTabInfo();
            }
        }
    }

    protected void updateTabInfo() {
        if (this.pageInfo == null) {
            return;
        }
        Component[] componentArray = new Component[this.pageInfo.size()];
        for (int i = 0; i < this.pageInfo.size(); ++i) {
            componentArray[i] = (Component)this.pageInfo.at(i);
        }
        int n = this.getSelectedIndex();
        for (int i = 0; i < this.model.getCount(); ++i) {
            if (i < componentArray.length) {
                if (componentArray[i] instanceof PlaceHolder) continue;
                this.cardLayout.removeLayoutComponent(componentArray[i]);
                this.cardLayout.addLayoutComponent(componentArray[i], this.model.get(i));
                if (n != i) continue;
                this.cardLayout.show(this, (String)this.model.get(i));
                continue;
            }
            this.pageInfo.add(new PlaceHolder());
        }
        for (int i = componentArray.length - 1; i >= this.model.getCount(); --i) {
            this.pageInfo.remove(i);
            if (componentArray[i] instanceof PlaceHolder) continue;
            super.remove(componentArray[i]);
        }
        super.updateTabInfo();
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(100, 100);
        if (!this.pageInfo.isEmpty()) {
            dimension = this.cardLayout.preferredLayoutSize(this);
            dimension.width = Math.max(dimension.width, super.getPreferredSize().width);
        }
        return dimension;
    }
}

