/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class ShapeControl
extends Component {
    public static final int RECTANGLE = 0;
    public static final int ROUND_RECT = 1;
    public static final int SQUARE = 2;
    public static final int ROUND_SQUARE = 3;
    public static final int ELLIPSE = 4;
    public static final int CIRCLE = 5;
    public static final int HORZ_LINE = 6;
    public static final int VERT_LINE = 7;
    public static final int POS_SLOPE_LINE = 8;
    public static final int NEG_SLOPE_LINE = 9;
    private int type = 0;
    private Color edgeColor = Color.black;
    private boolean drawEdge = true;
    private boolean fill = true;

    public ShapeControl() {
        this.setSize(100, 100);
        super.setForeground(Color.white);
    }

    public ShapeControl(int n) {
        this();
        this.setType(n);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint(100L);
    }

    public void setType(int n) {
        if (this.type != n) {
            this.type = n;
            this.repaint(100L);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
        this.repaint(100L);
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setEdgeColor(Color color) {
        this.edgeColor = color;
        this.repaint(100L);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setDrawEdge(boolean bl) {
        this.drawEdge = bl;
        this.repaint(100L);
    }

    public boolean isDrawEdge() {
        return this.drawEdge;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = 0;
        int n2 = 0;
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        int n5 = Math.min(n3, n4);
        if (this.type == 2 || this.type == 3 || this.type == 5) {
            n += (n3 - n5) / 2;
            n2 += (n4 - n5) / 2;
            n3 = n5;
            n4 = n5;
        }
        switch (this.type) {
            case 0: 
            case 2: {
                if (this.fill) {
                    graphics.setColor(this.getForeground());
                    graphics.fillRect(n, n2, n3, n4);
                }
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                break;
            }
            case 1: 
            case 3: {
                if (this.fill) {
                    graphics.setColor(this.getForeground());
                    graphics.fillRoundRect(n, n2, n3, n4, n5 / 4, n5 / 4);
                }
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawRoundRect(n, n2, n3 - 1, n4 - 1, n5 / 4, n5 / 4);
                break;
            }
            case 4: 
            case 5: {
                if (this.fill) {
                    graphics.setColor(this.getForeground());
                    graphics.fillOval(n, n2, n3, n4);
                }
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawOval(n, n2, n3 - 1, n4 - 1);
                break;
            }
            case 6: {
                graphics.setColor(this.getForeground());
                graphics.drawLine(n, n2, n + n3, n2);
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
                break;
            }
            case 7: {
                graphics.setColor(this.getForeground());
                graphics.drawLine(n, n2, n, n2 + n4);
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawLine(n + 1, n2, n + 1, n2 + n4);
                break;
            }
            case 8: {
                if (this.drawEdge) {
                    graphics.setColor(this.edgeColor);
                    graphics.drawLine(n, n2 + 1 + n4, n + n3, n2 + 1);
                }
                graphics.setColor(this.getForeground());
                graphics.drawLine(n, n2 + n4, n + n3, n2);
                break;
            }
            case 9: {
                if (this.drawEdge) {
                    graphics.setColor(this.edgeColor);
                    graphics.drawLine(n, n2 + 1, n + n3, n2 + n4 + 1);
                }
                graphics.setColor(this.getForeground());
                graphics.drawLine(n, n2, n + n3, n2 + n4);
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

