/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnVariant;
import borland.jbcl.dataset.DataRow;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.DataSetView;
import borland.jbcl.dataset.PickListDescriptor;
import borland.jbcl.dataset.ReadRow;
import borland.jbcl.dataset.RowFilterListener;
import borland.jbcl.model.ItemEditSite;
import borland.jbcl.model.ItemEditor;
import borland.jbcl.util.BlackBox;
import borland.jbcl.util.Variant;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.TooManyListenersException;

public class PickListItemEditor
extends Panel
implements ItemEditor,
ItemListener,
KeyListener,
BlackBox {
    String currentColumnName;
    String[] sourceColumns;
    String[] targetColumns;
    Column[] pickListColumns;
    String[] displayColumns;
    DataSetView pickListDataSet;
    DataSet targetDataSet;
    DataRow locateRow;
    boolean cache;
    Variant value;
    Choice choice = new Choice();
    RowFilterListener listener;
    ItemEditSite editSite;

    public PickListItemEditor() {
        this.setVisible(false);
        this.setLayout(new BorderLayout());
        this.cache = true;
        this.value = new Variant();
        this.choice.addItemListener(this);
        this.choice.addKeyListener(this);
    }

    public final void setCachePickList(boolean bl) {
        this.cache = bl;
    }

    public final boolean isCachePickList() {
        return this.cache;
    }

    public final void addRowFilterListener(RowFilterListener rowFilterListener) throws TooManyListenersException {
        if (rowFilterListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = rowFilterListener;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.addRowFilterListener(rowFilterListener);
        }
    }

    public final void removeRowFilterListener(RowFilterListener rowFilterListener) {
        this.listener = null;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.removeRowFilterListener(rowFilterListener);
        }
    }

    protected void loadPickList(PickListDescriptor pickListDescriptor) {
        if (this.pickListDataSet == null || !this.cache) {
            this.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (this.pickListDataSet == null) {
                    this.pickListDataSet = new DataSetView();
                    if (this.listener != null) {
                        this.pickListDataSet.addRowFilterListener(this.listener);
                    }
                    this.pickListDataSet.setStorageDataSet(pickListDescriptor.getPickListDataSet().getStorageDataSet());
                    this.sourceColumns = pickListDescriptor.getPickListColumns();
                    this.targetColumns = pickListDescriptor.getDestinationColumns();
                    this.displayColumns = pickListDescriptor.getPickListDisplayColumns();
                    if (this.sourceColumns == null || this.sourceColumns.length == 0 || this.targetColumns == null || this.targetColumns.length == 0 || this.displayColumns == null || this.displayColumns.length == 0) {
                        this.pickListDataSet = null;
                        return;
                    }
                }
                this.pickListDataSet.open();
                this.locateRow = new DataRow((DataSet)this.pickListDataSet, this.sourceColumns[0]);
                if (!this.cache) {
                    this.choice.removeAll();
                }
                int n = this.pickListDataSet.getColumn(this.displayColumns[0]).getOrdinal();
                if (this.listener != null) {
                    this.pickListDataSet.refilter();
                }
                this.pickListDataSet.first();
                while (this.pickListDataSet.inBounds()) {
                    this.choice.add(this.pickListDataSet.format(n));
                    this.pickListDataSet.next();
                }
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.choice, "Center");
                }
            }
            catch (Exception exception) {
                this.pickListDataSet = null;
                DataSetException.handleException(exception);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public Object getValue() {
        if (this.pickListDataSet != null) {
            try {
                this.pickListDataSet.goToRow(this.choice.getSelectedIndex());
                ReadRow.copyTo(this.sourceColumns, this.pickListDataSet, this.targetColumns, this.targetDataSet);
                for (int i = 0; i < this.targetColumns.length; ++i) {
                    if (!this.targetColumns[i].equalsIgnoreCase(this.currentColumnName)) continue;
                    this.pickListDataSet.getVariant(this.sourceColumns[0], this.value);
                    break;
                }
                Variant variant = this.value;
                return variant;
            }
            catch (DataSetException dataSetException) {
                this.value.setUnassignedNull();
                DataSetException.handleException(dataSetException);
            }
        }
        return this.value;
    }

    public Component getComponent() {
        return this;
    }

    public void startEdit(Object object, Rectangle rectangle, ItemEditSite itemEditSite) {
        Column column = null;
        ColumnVariant columnVariant = null;
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.editSite = itemEditSite;
        if (object instanceof ColumnVariant) {
            columnVariant = (ColumnVariant)object;
            this.value.setVariant(columnVariant);
            column = columnVariant.getColumn();
            this.currentColumnName = column.getColumnName();
            this.targetDataSet = columnVariant.getDataSet();
            this.loadPickList(column.getPickList());
            if (this.pickListDataSet == null) {
                itemEditSite.safeEndEdit(false);
            }
        }
        if (this.pickListDataSet != null && this.locateRow != null) {
            try {
                this.locateRow.setVariant(this.sourceColumns[0], (Variant)columnVariant);
                if (this.pickListDataSet.locate(this.locateRow, 32)) {
                    this.choice.select(this.pickListDataSet.getRow());
                }
            }
            catch (DataSetException dataSetException) {
                DataSetException.handleException(dataSetException);
            }
        }
        this.choice.invalidate();
        if (itemEditSite != null) {
            this.choice.setBackground(itemEditSite.getBackground());
            this.choice.setForeground(itemEditSite.getForeground());
            this.choice.setFont(itemEditSite.getFont());
        }
        this.validate();
        this.setVisible(true);
        this.choice.requestFocus();
    }

    public void changeBounds(Rectangle rectangle) {
        this.choice.invalidate();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.validate();
    }

    public boolean canPost() {
        return true;
    }

    public void endEdit(boolean bl) {
        this.setBounds(0, 0, 0, 0);
        this.setVisible(false);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this.choice.getSelectedIndex();
        switch (n) {
            case 39: 
            case 40: {
                if (n2 < this.choice.getItemCount() - 1) {
                    this.choice.select(n2 + 1);
                }
                keyEvent.consume();
                break;
            }
            case 37: 
            case 38: {
                if (n2 > 0) {
                    this.choice.select(n2 - 1);
                }
                keyEvent.consume();
                break;
            }
            case 36: {
                this.choice.select(0);
                keyEvent.consume();
                break;
            }
            case 35: {
                this.choice.select(this.choice.getItemCount() - 1);
                keyEvent.consume();
                break;
            }
            case 34: {
                this.choice.select(Math.min(n2 + 10, this.choice.getItemCount() - 1));
                keyEvent.consume();
                break;
            }
            case 33: {
                this.choice.select(Math.max(n2 - 10, 0));
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void addKeyListener(KeyListener keyListener) {
        this.choice.addKeyListener(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.choice.removeKeyListener(keyListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.choice.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.choice.removeFocusListener(focusListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getID() == 701) {
            this.editSite.safeEndEdit(true);
        }
    }
}

