/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.GroupBox;
import borland.jbcl.control.Res;
import borland.jbcl.layout.XYConstraints;
import borland.jbcl.layout.XYLayout;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class FontChooserPanel
extends Panel
implements ItemListener,
KeyListener {
    Font font;
    boolean changed;
    XYLayout xYLayout1 = new XYLayout();
    XYLayout xYLayout2 = new XYLayout();
    GroupBox groupBox1 = new GroupBox();
    List nameList = new List();
    TextField sizeField = new TextField();
    Label previewField = new Label();
    Checkbox boldBox = new Checkbox();
    Checkbox italicBox = new Checkbox();

    public FontChooserPanel() {
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FontChooserPanel(Font font) {
        this();
        this.setFontValue(font);
    }

    void init() {
        this.setLayout(this.xYLayout1);
        this.boldBox.setLabel(Res.getString(13));
        this.italicBox.setLabel(Res.getString(14));
        this.groupBox1.setLabel(Res.getString(16));
        this.previewField.setText(Res.getString(15));
        this.add((Component)this.nameList, new XYConstraints(13, 13, 158, 98));
        this.add((Component)this.boldBox, new XYConstraints(190, 14, 115, 20));
        this.add((Component)this.italicBox, new XYConstraints(190, 37, 115, 20));
        this.add((Component)this.groupBox1, new XYConstraints(182, 61, 110, 55));
        this.groupBox1.setLayout(new BorderLayout());
        this.groupBox1.add(this.sizeField);
        this.add((Component)this.previewField, new XYConstraints(11, 125, 278, 45));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String[] stringArray = toolkit.getFontList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.nameList.addItem(stringArray[i]);
        }
        this.nameList.addItemListener(this);
        this.boldBox.addItemListener(this);
        this.italicBox.addItemListener(this);
        this.sizeField.addKeyListener(this);
    }

    public Font getFontValue() {
        return this.font;
    }

    public void setFontValue(Font font) {
        if (font != null) {
            ((TextComponent)this.sizeField).setText(Integer.toString(font.getSize()));
            this.changeFont(font);
        } else {
            ((TextComponent)this.sizeField).setText("12");
            this.nameList.select(-1);
        }
        this.sizeField.setEnabled(font != null);
        this.boldBox.setEnabled(font != null);
        this.italicBox.setEnabled(font != null);
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void fontChanged(Font font) {
        this.changed = true;
    }

    protected void changeFont(Font font) {
        this.changeFont(font, false, false);
    }

    protected void changeFont(Font font, boolean bl, boolean bl2) {
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        if (font == null) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String[] stringArray = toolkit.getFontList();
        if (!bl && stringArray != null && this.nameList != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(font.getName())) continue;
                this.nameList.select(i);
                break;
            }
        }
        if (this.boldBox != null) {
            this.boldBox.setState(font.isBold());
        }
        if (this.italicBox != null) {
            this.italicBox.setState(font.isItalic());
        }
        this.previewField.setFont(font);
        this.fontChanged(font);
    }

    int getFontSize() {
        try {
            int n = Integer.parseInt(this.sizeField.getText());
            if (n > 30000) {
                ((TextComponent)this.sizeField).setText(String.valueOf(30000));
            }
            int n2 = Math.min(n, 30000);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.nameList.getSelectedItem();
        this.sizeField.setEnabled(true);
        this.boldBox.setEnabled(true);
        this.italicBox.setEnabled(true);
        Font font = new Font(string != null ? string : "Dialog", (this.boldBox.getState() ? 1 : 0) + (this.italicBox.getState() ? 2 : 0), this.getFontSize());
        this.changeFont(font, itemEvent != null && itemEvent.getSource() instanceof List, false);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.itemStateChanged(null);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 8;
        dimension.height += 8;
        return dimension;
    }
}

