/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import COM.objectspace.jgl.HashMap;
import borland.jbcl.control.AspectPicker;
import borland.jbcl.control.BevelPanel;
import borland.jbcl.control.GroupBox;
import borland.jbcl.control.Res;
import borland.jbcl.control.ShapeControl;
import borland.jbcl.control.SplitPanel;
import borland.jbcl.layout.PaneConstraints;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class ColorChooserPanel
extends BevelPanel
implements AdjustmentListener,
KeyListener,
ItemListener {
    public static final String CUSTOM_TAG = Res.getString(44);
    static final String[][] colorNames = new String[][]{{Res.getString(208), "Color.white"}, {Res.getString(209), "Color.lightGray"}, {Res.getString(210), "Color.gray"}, {Res.getString(211), "Color.darkGray"}, {Res.getString(212), "Color.black"}, {Res.getString(213), "Color.red"}, {Res.getString(214), "Color.pink"}, {Res.getString(215), "Color.orange"}, {Res.getString(216), "Color.yellow"}, {Res.getString(217), "Color.green"}, {Res.getString(218), "Color.magenta"}, {Res.getString(219), "Color.cyan"}, {Res.getString(220), "Color.blue"}, {Res.getString(221), "SystemColor.desktop"}, {Res.getString(222), "SystemColor.activeCaption"}, {Res.getString(223), "SystemColor.activeCaptionText"}, {Res.getString(224), "SystemColor.activeCaptionBorder"}, {Res.getString(225), "SystemColor.inactiveCaption"}, {Res.getString(226), "SystemColor.inactiveCaptionText"}, {Res.getString(227), "SystemColor.inactiveCaptionBorder"}, {Res.getString(228), "SystemColor.window"}, {Res.getString(229), "SystemColor.windowBorder"}, {Res.getString(230), "SystemColor.windowText"}, {Res.getString(231), "SystemColor.menu"}, {Res.getString(232), "SystemColor.menuText"}, {Res.getString(233), "SystemColor.text"}, {Res.getString(234), "SystemColor.textText"}, {Res.getString(235), "SystemColor.textHighlight"}, {Res.getString(236), "SystemColor.textHighlightText"}, {Res.getString(237), "SystemColor.textInactiveText"}, {Res.getString(238), "SystemColor.control"}, {Res.getString(239), "SystemColor.controlText"}, {Res.getString(240), "SystemColor.controlHighlight"}, {Res.getString(241), "SystemColor.controlLtHighlight"}, {Res.getString(242), "SystemColor.controlShadow"}, {Res.getString(243), "SystemColor.controlDkShadow"}, {Res.getString(244), "SystemColor.scrollbar"}, {Res.getString(245), "SystemColor.info"}, {Res.getString(246), "SystemColor.infoText"}, {CUSTOM_TAG, CUSTOM_TAG}};
    static final Color[] colorValues = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue, SystemColor.desktop, SystemColor.activeCaption, SystemColor.activeCaptionText, SystemColor.activeCaptionBorder, SystemColor.inactiveCaption, SystemColor.inactiveCaptionText, SystemColor.inactiveCaptionBorder, SystemColor.window, SystemColor.windowBorder, SystemColor.windowText, SystemColor.menu, SystemColor.menuText, SystemColor.text, SystemColor.textText, SystemColor.textHighlight, SystemColor.textHighlightText, SystemColor.textInactiveText, SystemColor.control, SystemColor.controlText, SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlDkShadow, SystemColor.scrollbar, SystemColor.info, SystemColor.infoText, null};
    static HashMap textToValueMap;
    static HashMap localizedTextToValueMap;
    private Color value;
    private ShapeControl sample = new ShapeControl(1);
    private Checkbox[] checkbox = new Checkbox[2];
    private String[] rgbLabels = new String[]{Res.getString(38), Res.getString(39), Res.getString(40)};
    private String[] hsbLabels = new String[]{Res.getString(41), Res.getString(42), Res.getString(43)};
    private int[] comp = new int[3];
    private boolean hsbMode = false;
    private boolean changed = false;
    private String[] text = new String[3];
    private Choice choice = new Choice();
    private AspectPicker[] pickers = new AspectPicker[3];

    public ColorChooserPanel() {
        this.setBevelInner(0);
        this.setMargins(new Insets(0, 5, 5, 5));
        try {
            this.jbInit();
            this.hsbMode = true;
            this.setHsbMode(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.value = Color.white;
    }

    public ColorChooserPanel(Color color) {
        this();
        this.value = color;
    }

    void jbInit() throws Exception {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 0));
        panel.add(new Label(Res.getString(36)));
        this.fillChoice();
        this.choice.addItemListener(this);
        panel.add(this.choice);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 3));
        for (int i = 0; i < 3; ++i) {
            this.pickers[i] = new AspectPicker();
            this.pickers[i].text.addKeyListener(this);
            this.pickers[i].scrollbar.addAdjustmentListener(this);
            panel2.add(this.pickers[i]);
        }
        Panel panel3 = new Panel();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.checkbox[0] = new Checkbox("RGB", false, checkboxGroup);
        panel3.add(this.checkbox[0]);
        this.checkbox[1] = new Checkbox("HSB", false, checkboxGroup);
        panel3.add(this.checkbox[1]);
        this.checkbox[0].addItemListener(this);
        this.checkbox[1].addItemListener(this);
        GroupBox groupBox = new GroupBox(Res.getString(35));
        groupBox.setLayout(new BorderLayout());
        groupBox.add((Component)panel2, "Center");
        groupBox.add((Component)panel3, "South");
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.add((Component)new Label(Res.getString(37)), "North");
        panel4.add((Component)this.sample, "Center");
        PaneConstraints paneConstraints = new PaneConstraints();
        paneConstraints.position = "Left";
        SplitPanel splitPanel = new SplitPanel();
        splitPanel.add((Component)groupBox, paneConstraints);
        paneConstraints.position = "Right";
        paneConstraints.proportion = 0.3f;
        splitPanel.add((Component)panel4, paneConstraints);
        splitPanel.setGap(2);
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)panel, "North");
        this.add((Component)splitPanel, "Center");
    }

    public Color getColorValue() {
        return this.value;
    }

    public void setColorValue(Color color) {
        this.changeColor(color);
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void colorChanged(Color color) {
        this.changed = true;
    }

    protected void changeColor(Color color) {
        this.changeColor(color, false, false);
    }

    protected void changeColor(Color color, boolean bl, boolean bl2) {
        if (color != null && color.equals(this.value)) {
            return;
        }
        this.value = color;
        if (color == null) {
            return;
        }
        if (!this.hsbMode) {
            this.comp[0] = color.getRed();
            this.comp[1] = color.getGreen();
            this.comp[2] = color.getBlue();
        } else {
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.comp[0] = (int)(fArray[0] * (float)100);
            this.comp[1] = (int)(fArray[1] * (float)100);
            this.comp[2] = (int)(fArray[2] * (float)100);
        }
        for (int i = 0; i < 3; ++i) {
            int n;
            if (!bl) {
                String string = Integer.toString(this.comp[i]);
                if (this.text[i] == null || !this.text[i].equals(string)) {
                    this.text[i] = string;
                    ((TextComponent)this.pickers[i].text).setText(string);
                }
            }
            int n2 = n = this.hsbMode ? 100 : 255;
            if (bl2 || this.pickers[i].scrollbar.getValue() == this.comp[i]) continue;
            this.pickers[i].scrollbar.setValues(this.comp[i], 0, 0, n + 1);
        }
        String string = ColorChooserPanel.valueToText(color, true);
        if (string != null) {
            this.choice.select(string);
        }
        if (color != this.sample.getForeground()) {
            this.sample.setForeground(color);
        }
        if (!this.hsbMode) {
            this.pickers[0].sample.setForeground(new Color(255, 255 - this.comp[0], 255 - this.comp[0]));
            this.pickers[1].sample.setForeground(new Color(255 - this.comp[1], 255, 255 - this.comp[1]));
            this.pickers[2].sample.setForeground(new Color(255 - this.comp[2], 255 - this.comp[2], 255));
        }
        this.colorChanged(color);
    }

    public void setHsbMode(boolean bl) {
        if (this.hsbMode != bl) {
            this.hsbMode = bl;
            int n = bl ? 100 : 255;
            for (int i = 0; i < 3; ++i) {
                this.pickers[i].label.setText(bl ? this.hsbLabels[i] : this.rgbLabels[i]);
                this.pickers[i].scrollbar.setValues(this.comp[i], 0, 0, n + 1);
                this.pickers[i].sample.setVisible(!bl);
            }
            this.checkbox[0].setState(!bl);
            this.checkbox[1].setState(bl);
            Color color = this.value;
            this.value = null;
            this.changeColor(color);
        }
    }

    public boolean isHsbMode() {
        return this.hsbMode;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Color color = this.hsbMode ? Color.getHSBColor(Math.min((float)this.pickers[0].scrollbar.getValue() / 100.0f, 0.999999f), (float)this.pickers[1].scrollbar.getValue() / 100.0f, (float)this.pickers[2].scrollbar.getValue() / 100.0f) : new Color(this.pickers[0].scrollbar.getValue(), this.pickers[1].scrollbar.getValue(), this.pickers[2].scrollbar.getValue());
        if (!color.equals(this.value)) {
            this.changeColor(color, false, false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        try {
            Color color;
            int[] nArray = new int[3];
            boolean bl = false;
            int n = this.hsbMode ? 100 : 255;
            for (int i = 0; i < 3; ++i) {
                nArray[i] = Integer.parseInt(this.pickers[i].text.getText());
                if (nArray[i] >= 0 && nArray[i] <= n) continue;
                bl = true;
            }
            if (!bl && !(color = this.hsbMode ? Color.getHSBColor(Math.min((float)nArray[0] / 100.0f, 0.999999f), (float)nArray[1] / 100.0f, (float)nArray[2] / 100.0f) : new Color(nArray[0], nArray[1], nArray[2])).equals(this.value)) {
                this.changeColor(color, true, false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choice) {
            Color color = ColorChooserPanel.textToValue(this.choice.getSelectedItem(), true);
            if (color != null) {
                this.changeColor(color, false, false);
            }
        } else {
            this.setHsbMode(itemEvent.getItemSelectable() == this.checkbox[1]);
        }
    }

    void fillChoice() {
        for (int i = 0; i < colorValues.length; ++i) {
            this.choice.add(colorNames[i][0]);
        }
    }

    public static String valueToText(Color color, boolean bl) {
        for (int i = 0; i < colorValues.length; ++i) {
            if (color != colorValues[i]) continue;
            return bl ? colorNames[i][0] : colorNames[i][1];
        }
        for (int i = 0; i < colorValues.length; ++i) {
            if (!color.equals(colorValues[i])) continue;
            return bl ? colorNames[i][0] : colorNames[i][1];
        }
        return CUSTOM_TAG;
    }

    public static Color textToValue(String string, boolean bl) {
        return bl ? (Color)localizedTextToValueMap.get(string) : (Color)textToValueMap.get(string);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 40;
        return dimension;
    }

    static {
        int n = 0;
        try {
            textToValueMap = new HashMap();
            localizedTextToValueMap = new HashMap();
            for (n = 0; n < colorValues.length; ++n) {
                if (colorValues[n] == null) continue;
                localizedTextToValueMap.put(colorNames[n][0], colorValues[n]);
                textToValueMap.put(colorNames[n][1], colorValues[n]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("color values len ").concat(String.valueOf(n))).concat(String.valueOf(" "))).concat(String.valueOf(colorValues[n]))).concat(String.valueOf(colorNames[n][0]))).concat(String.valueOf(colorNames[n][1])));
        }
    }
}

