/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.FieldControl;
import borland.jbcl.control.Res;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.BasicViewManager;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.SingletonModelEvent;
import borland.jbcl.util.BlackBox;
import borland.jbcl.util.ImageLoader;
import borland.jbcl.util.Variant;
import borland.jbcl.view.FocusableItemPainter;
import borland.jbcl.view.ImageItemEditor;
import borland.jbcl.view.ImageItemPainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;

public class ImageControl
extends FieldControl
implements BlackBox {
    private String imageName;
    private URL url;
    private String boundName;
    private Variant value = new Variant();

    public ImageControl() {
        this.setAlignment(68);
        this.setPreferredHeight(100);
        this.setEditInPlace(false);
        this.defaultLayout();
    }

    protected void defaultLayout() {
        this.setModel(new BasicSingletonContainer());
        this.setViewManager(new BasicViewManager(new FocusableItemPainter(new ImageItemPainter(this, this.getAlignment())), new ImageItemEditor()));
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(77));
        }
        super.setModel(singletonModel);
    }

    public void setImageName(String string) throws IOException {
        if (string != null && !string.equals("")) {
            this.setupImage(ImageLoader.load(string, (Component)this), string);
        } else {
            if (this.isReadOnly()) {
                throw new IllegalStateException(Res.getString(70));
            }
            this.imageName = null;
            this.getWriteModel().set(null);
        }
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImage(Image image) throws IOException {
        this.setupImage(image, "");
    }

    public Image getImage() {
        Object object = this.getModel().get();
        return object instanceof Image ? (Image)object : null;
    }

    public void setImageURL(URL uRL) throws IOException {
        this.url = uRL;
        this.setupImage(ImageLoader.load(uRL, (Component)this), uRL.toString());
    }

    public URL getImageURL() {
        return this.url;
    }

    protected void setupImage(Image image, String string) throws IOException {
        Graphics graphics;
        if (this.isReadOnly()) {
            throw new IllegalStateException(Res.getString(70));
        }
        this.prepareImage(image, this);
        if ((this.checkImage(image, this) & 0x40) != 0) {
            throw new IOException(Res.format(22, new String[]{string}));
        }
        this.imageName = string;
        if (this.isVisible() && (graphics = this.getGraphics()) != null) {
            Rectangle rectangle = this.getInnerRect(graphics);
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(image);
        }
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        Graphics graphics;
        if (this.isVisible() && (graphics = this.getGraphics()) != null) {
            Rectangle rectangle = this.getInnerRect(graphics);
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        super.modelContentChanged(singletonModelEvent);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 0) {
            this.invalidate();
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    protected void updateSelection() {
        if (this.getDataSet() != null && this.getColumnName() != null) {
            try {
                this.getDataSet().getVariant(this.getColumnName(), this.value);
                try {
                    Image image = ImageLoader.loadFromBlob(this.value, this, true);
                    this.setupImage(image, "");
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.repaint(100L);
    }
}

