/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.projectman;

import org.freebuilder.system.classes.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.debug.Debug;
import java.util.*;

/** The Project Manager manage the whole project. It is subclass of kinds BrowseCollection
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
*/

public class ProjectManager extends BrowseManager {
  public  static final String cProjectFileExt = ".jpr";
  private static       int    NewProjectsCntr = 1;

  public ProjectManager() {
    super();
  }

  private String getNewProjectName() {
    String NewName = Globals.getCrntDir() + Globals.FileSeparator + "Project";
    NewName = NewName + NewProjectsCntr++ + cProjectFileExt;
    return NewName; 
  }

  /** return Project Options if there is an opened project, otherwise return null */
  public BrowseCollection getBrowseCollOptions() { // Override
    ProjectOptions BrOpts = null; if (Globals.Options == null) return null;
    BrOpts = (ProjectOptions)(Globals.Options.getOptions(ProjectOptions.cDefaultName));
    return BrOpts;
  }

  protected String getBrowseCollOptionsName() { // Override
    return ProjectOptions.cDefaultName;
  }

  public void AddListeners() { // Override
    super.AddListeners();
    Globals.AddDoProjectManEAdapter(ProjectManEvent.msgCloseProject , this,"DoCloseProject");
    Globals.AddDoProjectManEAdapter(ProjectManEvent.msgSaveProject  , this,"DoSaveProject");
    Globals.AddDoProjectManEAdapter(ProjectManEvent.msgSaveProjectAs, this,"DoSaveProjectAs");
    Globals.AddDoProjectManEAdapter(ProjectManEvent.msgCreateProject, this,"DoCreateProject");
    Globals.AddDoProjectManEAdapter(ProjectManEvent.msgOpenProject  , this,"DoTryToOpenProject");
  }

  //------------------------------------------------------------------------------------
  //  Begin of message handler functions
  //------------------------------------------------------------------------------------

  /** Additional things which can be done, after successful operation */
  protected void OnCloseOpenCreate(ProjectManEvent PmEvent) {
    if (PmEvent == null) return;
    if (! PmEvent.Done ) return;

//    Globals.RootPaths.RefreshPaths();
  }

  protected ProjectManEvent CheckProjectManEvent(IdeSuperEvent AEvent) {
    ProjectManEvent PmEvent = (ProjectManEvent)AEvent; if (PmEvent == null) return null;
    if (PmEvent.PrConf == null) {
      Debug.Assert(this, "CheckProjectManEvent : PmEvent.PrConf == null"); return null;
    }
    return PmEvent;
  }

  public void DoCloseProject(IdeSuperEvent AEvent) {
    ProjectManEvent PmEvent = CheckProjectManEvent(AEvent); if (PmEvent == null) return;
    if (!PmEvent.CanDoThat) return;
    Globals.Options.CloseLastProject();
    PmEvent.Done = true;
    OnCloseOpenCreate(PmEvent);
  }

  public void DoSaveProject(IdeSuperEvent AEvent) {
    ProjectManEvent PmEvent = CheckProjectManEvent(AEvent); if (PmEvent == null) return;
    if (!PmEvent.CanDoThat) return;
    PmEvent.Done = Globals.Options.SaveProject();
  }

  public void DoSaveProjectAs(IdeSuperEvent AEvent) {
    ProjectManEvent PmEvent = CheckProjectManEvent(AEvent); if (PmEvent == null) return;
    if (!PmEvent.CanDoThat) return;
    if (PmEvent.FName == null) return;
    if (PmEvent.FName.length() == 0) return;
    PmEvent.Done = Globals.Options.SaveProjectAs(PmEvent.FName);
  }

  public void DoCreateProject(IdeSuperEvent AEvent) {
    ProjectManEvent PmEvent = (ProjectManEvent)AEvent; if (PmEvent == null) return;
    if (!PmEvent.CanDoThat) return;
    if (PmEvent.FName == null) return;
    if (PmEvent.FName.length() == 0) return;
    Globals.Options.CreateNewProject(PmEvent.FName);
    PmEvent.Done = true;
    OnCloseOpenCreate(PmEvent);
  }

  public void DoTryToOpenProject(IdeSuperEvent AEvent) {
    ProjectManEvent PmEvent = (ProjectManEvent)AEvent; if (PmEvent == null) return;
    if (!PmEvent.CanDoThat) return;
    if (PmEvent.FName == null) return;
    if (PmEvent.FName.length() == 0) return;
    PmEvent.Done = Globals.Options.OpenProject(PmEvent.FName);
    OnCloseOpenCreate(PmEvent);
  }
  //------------------------------------------------------------------------------------
  //  End   of message handler functions
  //------------------------------------------------------------------------------------
  ProjectManEvent AllwaysSendPrManEvent(int EventID, String FName) {
    if (! IsSendEventsEnabled) return null;
    ProjectConfig PrConf = Globals.Options.getProjectOptions();

    ProjectManEvent PrEvent = new ProjectManEvent(EventID, new EventObject(this), PrConf, FName);
    Globals.EventsEngine.SendEvent(PrEvent);
    return PrEvent;
  }

  /** retrun false, if somebody which is received the message Does not want to continue operation */
  ProjectManEvent SendPrManEvent(int EventID, String FName) {
    if (! isOpenedProject()) return null;
    ProjectConfig PrConf = Globals.Options.getProjectOptions(); if (PrConf == null) return null;
    return AllwaysSendPrManEvent(EventID, FName);
  }

  public boolean isOpenedProject() {
    return Globals.Options.isOpenedProject();
  }

  public boolean CloseProject() {
    ProjectManEvent PrEvent;
    if (! isOpenedProject()) return true;
    PrEvent = SendPrManEvent(ProjectManEvent.msgCloseProject, "");
    if (PrEvent == null) return false;
    return PrEvent.Done;
  }

  public boolean CloseProjectAndRefresh() {
    boolean Result = CloseProject();
// Altered by Peko. Was this
//    Globals.Options.Refresh(); ?????????????????????????????
    if (Result)
      Globals.Options.Refresh();
// End Alter
    return Result;
  }

  public boolean SaveProject() {
    ProjectManEvent PrEvent = SendPrManEvent(ProjectManEvent.msgSaveProject, "");
    if (PrEvent == null) return false;
    return PrEvent.Done;
  }

  public boolean SaveProjectAs(String NewFileName) {
    if ((! isOpenedProject()) || (NewFileName == null) ) return false;
    if (NewFileName.length() == 0) return false;
    ProjectManEvent PrEvent = SendPrManEvent(ProjectManEvent.msgSaveProjectAs, NewFileName);
    if (PrEvent == null) return false;
    return PrEvent.Done;
  }

  public boolean CreateNewProject() {
    String NewProjectName = getNewProjectName();
    return CreateNewProject(NewProjectName);
  }

  public boolean CreateNewProject(String AProjectName) {
    if (! CloseProject()) return false;
    ProjectManEvent PrEvent = AllwaysSendPrManEvent(ProjectManEvent.msgCreateProject, AProjectName);
    if (PrEvent == null) return false;
    return PrEvent.Done;
  }

  protected boolean TryToOpenProject(String AFileName) {
    if (! CloseProject()) return false;
    ProjectManEvent PrEvent = AllwaysSendPrManEvent(ProjectManEvent.msgOpenProject, AFileName);
    if (PrEvent == null) return false;
    return PrEvent.Done;
  }

  public boolean OpenProject(String AFileName) {
    if (AFileName == null) return false; if (AFileName.length() == 0) return false;
    if (! CloseProject()) return false;
    if (TryToOpenProject(AFileName)) return true;
    if (! CreateNewProject(AFileName)) return false;
    SaveProject();
    return true;
  }
}
