/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.debug;

import java.lang.*;

/** Java does not have atleast a conditional compiling, Assert or something else which can help us
  * find the errors automatically.
  * Class <code>Debug</code> defines some static Assert methods which prints the error and eventually terminate
  * the program. When you test the code you must set isDebug to true. At the final release version set it
  * to false. This is too simple and no so good way. But this is Java.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class Debug {
  /** Is this a Test (Debug) mode of the program ? */
  static public boolean isDebug        = false;
  static public boolean isToExitSystem = false;
  static int TitlePrintCntr = 0;

  public static void PrintTitle() {
    if (TitlePrintCntr++ != 0) return;
    System.out.println("Begin of Assert ----------------------------------------------------------------------------------------------------");
  }

  public static void PrintEnd() {
    if (TitlePrintCntr != 0) TitlePrintCntr--;
    if (TitlePrintCntr != 0) return;
    System.out.println("End   of Assert ----------------------------------------------------------------------------------------------------");
  }

  private static void ExitWithError(Object Sender, String MsgString) {
    Class SenderClass;
    if (! isDebug) return;

    PrintTitle();
    try {
      System.out.println("");
      if(Sender != null) {
        System.out.println("Assert : was thrown by " + Sender);
      };
      System.out.println("Assert : Assert message is : " + MsgString);
    }
    finally {
      PrintEnd();
    }
    if (isToExitSystem)
      System.exit(1);
  }

  public static void Assert(Object Sender, String MsgString) {
    Assert(new AssertException(MsgString), Sender, MsgString);
  }

  public static void Assert(boolean Condition, String MsgString) {
    if (Condition) return;
    Assert(new AssertException(MsgString), null, MsgString);
  }

  public static void Assert(boolean Condition, Object Sender, String MsgString) {
    if (Condition) return;
    Assert(new AssertException(MsgString), Sender, MsgString);
  }

  public static void Assert(String MsgString) {
    Assert(new AssertException(MsgString), null, MsgString);
  }

  public static void PrintException(Throwable e, String Title) {
    if (Title != null)
      if (Title.length() > 0) {
        System.out.println(Title);
        System.out.println("");
      }

    if (e != null) {
      System.out.println("Assert : Exception Object  is : " + e);
      System.out.println("Assert : Exception Message is : " + e.getMessage());
      System.out.println("Assert : Stack trace for the exception");
      e.printStackTrace();
      System.out.println("");
    }
    else System.out.println("Assert : Exception object is null ! ");
  }

  public static void Assert(Throwable e, Object Sender) {
    String ExcStr = null;
    PrintTitle();
    try {
      PrintException(e, "");
      if (e != null) ExcStr = e.getMessage();
      if (ExcStr != null) ExitWithError(Sender, ExcStr);
      else                ExitWithError(Sender, "");
    }
    finally {
      PrintEnd();
    }
  }

  public static void Assert(Throwable e, Object Sender, String MsgString) {
    if (! isDebug) return;
    PrintTitle();
    try {
      PrintException(e, "");
      ExitWithError(Sender, MsgString);
    }
    finally {
      PrintEnd();
    }
  }
}
