/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.options;

import java.util.EventObject;
import java.lang.*;
import java.io.*;

/** Every class which will be used like Options container have to implement <code>OptionsSuperI</code>
  * All the objects which implements <code>OptionsSuperI</code> interface can be used like Options container
  * and managed by OptionsColl object. It is responsible for the Object to save the Name of Options
  * (returned by getName()) and all other options.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */


public interface OptionsSuperI extends Serializable {
  /** Have to use Clonable to Clone the Object with that interface. This is neccessary to make a
    * mirror of the Options, and to work with them. This method is not a standard clone() method.
    * In this way you can return a Object member of the class which implements this interface.
    * For example if it is neccessary to Save / Load a bounds of some subclass of a frame object (SomeFrame),
    * you can say that SomeFrame will implement OptionsSuperI, and have onother object which will contain the
    * bounds of SomeFrame. In this way the OptionsColl will Clone only this object, not the whole SomeFrame.
    */
  public OptionsSuperI Clone() throws CloneNotSupportedException;

  /** Compares the datas for the options included in both objects and returns the result. */
  public boolean IsDifferent(OptionsSuperI TheOtherOne);

  /** This method prepare the event object which will be posed. */
  public OptionsEvent PrepareEvent(int EventNumber);

  /** Every Options object must have a Name. This function return it's name. This name is used
    * in sending a events, or of choosing the options. Options are choosed by this name */
  public String getName();

  /** Set default values for this options */
  public void setDefaults();
}
