/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events.engine;

import org.freebuilder.system.debug.Debug;
import java.util.EventObject;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

/** The class <code>MethodCallAdapter</code>
  * Method to call must have this syntacsys :
  * public void SomeMethod(IdeSuperEventI AEvent);
  * This is the super class for all the events which will be Dispatched via IdeEventsEngin
  * Every new Event have to derive from EventObject, because every event has a source (Sender)
  * This is the super class for all the events which will be Dispatched via IdeEventsEngin
  * Every new Event have to derive from IdeSuperEvent.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */
  
public class MethodCallAdapter extends IdeEventListenerAC {
  Object  MethodRef;       // Instance reference to Object wich Method wich will be called
  String  MethodName;      // It's name.
  Method  MethodToInvoke;  // Class.invoke requires object of this type.
  Object  Args      [];    // Array of objects, which will be passed as method arguments

  public MethodCallAdapter(int ACallMask, Object AMethodRef, String AMethodName)
    throws NoSuchMethodException, SecurityException {

    super(ACallMask);
    MethodRef      = AMethodRef;
    MethodName     = AMethodName;
    Args           = new Object[1]; Args [0] = null;
    MethodToInvoke = null;

    if (MethodRef == null) return;

    Class         ArgTypes[] = new Class [1];          // Type of every argument.
    IdeSuperEvent AEvent     = new IdeSuperEvent(new EventObject(this));  // This method will have only one argument of this type.
    ArgTypes[0]              = AEvent.getClass();

    Class MethodRefClass     = MethodRef.getClass();

    MethodToInvoke = MethodRefClass.getMethod(MethodName,ArgTypes);
  }

  String getMethodName() {
    return MethodRef.getClass().getName() + '.' + MethodName;
  }

  void PrintException(Throwable e, String TheMessage) {
    if (! Debug.isDebug) return;
    Debug.PrintTitle();
    System.out.println(this.getClass().getName() + ".invoke(" + getMethodName() + ");  throws exception ");
    System.out.println("");
    Debug.Assert(e, this, TheMessage);
    Debug.PrintEnd();
  }

  protected void InvokeMethod(IdeSuperEvent AEvent) {
    Throwable OriginException = null;

    if (MethodRef == null) { if (Debug.isDebug) Debug.Assert(this,"Method ref == null"); return; }
    Debug.Assert(AEvent != null, MethodRef, "Event passed to the Method " + MethodRef.getClass().getName() + '.' + MethodName + "is null");

    try {
      Args[0] = AEvent;
      MethodToInvoke.invoke(MethodRef,Args);
    }

    catch (IllegalAccessException e) {
      PrintException(e, "You have not rights to invoke this melthod. It have to be public ");
    }

    catch (IllegalArgumentException e) {
      PrintException(e, "Method prototyping is diffrent than : public void SomeMethod(IdeSuperEventI AEvent)");
    }

    catch (InvocationTargetException e) {
      if (! Debug.isDebug) return;
      Debug.PrintTitle();
      PrintException(e,"");
      System.out.println("");
      System.out.println("");
      System.out.println(" This exception is a result of following exception : ");
      OriginException = e.getTargetException();
      Debug.Assert(OriginException, this, "");
      // PrintException(OriginException,"");
      Debug.PrintEnd();
    }

    catch (NullPointerException e) {
      PrintException(e, "invoke throw NullPointerException");
    }

    catch (Exception e){
      PrintException(e, "Exception on method invokation ");
    }
  }

  public void BeforeAction(IdeSuperEvent AEvent) {InvokeMethod(AEvent);}
  public void OnAction    (IdeSuperEvent AEvent) {InvokeMethod(AEvent);}
  public void AfterAction (IdeSuperEvent AEvent) {InvokeMethod(AEvent);}
}

