/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.xysaveframe;

import java.awt.*;
import java.awt.event.*;
import org.freebuilder.system.classes.options.*;

/** The <code>XyFrameOptions</code> class is used to save size and location properties for some frame.
  * You just have to pass to it a frame which options will be saved & the name of the options.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class XyFrameOptions extends OptionsSuper {
  public static final String cDefaultName = "FrameOptions";

  private String   OptionsName   = cDefaultName; // Options will be Referenced by a name.
  public  Dimension frameSize     = null;
  public  Point     frameLocation = null;

  public XyFrameOptions(String AOptionsName) {
    setDefaults();
    OptionsName = AOptionsName;
  }

  /** @param AFrame frame which options will be saved and restored
    * @param AOptionsName options name for this frame */
  public XyFrameOptions(Frame AFrame, String AOptionsName) {
    this(AOptionsName);
    frameSize     = AFrame.getSize();
    frameLocation = AFrame.getLocation();
  }

  public OptionsSuperI Clone() throws CloneNotSupportedException {
    return (OptionsSuperI)clone();
  }

  public String getName() {
    return OptionsName;
  }

  /** This method sets size to (300,200) and center the frame to the center of the screen
    * If you want other default sizes & positions you have to override this method. */
  public void setDefaults() {
    Dimension screenSize = null;

    if (frameSize == null) frameSize     = new Dimension();
    frameSize.setSize(400,400);

    if (frameLocation == null) frameLocation = new Point();

    screenSize = Toolkit.getDefaultToolkit().getScreenSize(); // Let's center it.
    if (frameSize.height > screenSize.height) frameSize.height = screenSize.height;
    if (frameSize.width  > screenSize.width)  frameSize.width  = screenSize.width;
    frameLocation.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
  }

  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    XyFrameOptions OOptions = (XyFrameOptions)TheOtherOne;
    if (TheOtherOne == null) return true;
    if (! frameSize    .equals(OOptions.frameSize))     return true;
    if (! frameLocation.equals(OOptions.frameLocation)) return true;
    return false;
  }
}


