/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions;

import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.projectman.*;
import org.freebuilder.system.ideengine.*;
import java.util.EventObject;
import java.util.Vector;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.config.*;
import pizza.compiler.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class PizzaCompilerOptions implements OptionsSuperI, Cloneable {
  public static final String PizzaCompilerOptionsName = "Pizza Compiler Options";
  private boolean Experimental;
  private boolean Debug;
  private boolean JavaOnly;
  private boolean Emit;
  private boolean Scramble;
  private boolean ScrambleAll;
  private boolean SwitchCheck;
  private boolean Verbose;
  private boolean Version;
  private boolean PrintSearch;

/*
  -experimental           Enable experimental features
  -g                      include debug information
  -java                   accept only standard Java input
  -pizza                  accept standard Pizza input
  -printsearch            print information where classfiles are searched
  -s                      emit java sources instead of classfiles
  -scramble               scramble private identifiers in bytecode
  -scrambleall            scramble package visible identifiers in bytecode
  -switchcheck            warn about fall-through in switches
  -verbose                print detailed log
  -version                version information
*/

  public void initCompiler (pizza.compiler.Main PizzaCompiler) {
    PizzaCompiler.init ();

    if (isExperimental())
      PizzaCompiler.argument ("-experimental");
    if (isDebug())
      PizzaCompiler.argument ("-g");
    if (isPrintSearch())
      PizzaCompiler.argument ("-printsearch");
    if (isEmit())
      PizzaCompiler.argument ("-s");
    if (isScramble())
      PizzaCompiler.argument ("-scramble");
    if (isScrambleAll())
      PizzaCompiler.argument ("-scrambleall");
    if (isSwitchCheck())
      PizzaCompiler.argument ("-swtchcheck");
    if (isVerbose())
      PizzaCompiler.argument ("-verbose");
    if (isVersion())
      PizzaCompiler.argument ("-version");

    if (isJavaOnly())
      PizzaCompiler.argument ("-java");
    else
      PizzaCompiler.argument ("-pizza");


    PathsOptions POptions = (PathsOptions) Globals.Options.getOptions(PathsOptions.PathsOptionsName);
//    PizzaCompiler.argument ("-d");
    PizzaCompiler.setDestinationDir (POptions.getClassOutPath());
//    PizzaCompiler.argument ("-classpath");
    String TheClassPath = PathEditorDialog.getPath(POptions.getClassPath());
    TheClassPath += ";" + POptions.getClassOutPath();
    PizzaCompiler.setClassPath (TheClassPath);
  }

  public void setExperimental (boolean NewValue) {
    Experimental = NewValue;
  }
  public void setDebug (boolean NewValue) {
    Debug = NewValue;
  }
  public void setJavaOnly (boolean NewValue) {
    JavaOnly = NewValue;
  }
  public void setEmit (boolean NewValue) {
    Emit = NewValue;
  }
  public void setScramble (boolean NewValue) {
    Scramble = NewValue;
  }
  public void setScrambleAll (boolean NewValue) {
    ScrambleAll = NewValue;
  }
  public void setSwitchCheck (boolean NewValue) {
    SwitchCheck = NewValue;
  }
  public void setVerbose (boolean NewValue) {
    Verbose = NewValue;
  }
  public void setVersion (boolean NewValue) {
    Version = NewValue;
  }
  public void setPrintSearch (boolean NewValue) {
    PrintSearch = NewValue;
  }

  public boolean isExperimental () {
    return Experimental;
  }
  public boolean isDebug () {
    return Debug;
  }
  public boolean isJavaOnly () {
    return JavaOnly;
  }
  public boolean isEmit () {
    return Emit;
  }
  public boolean isScramble () {
    return Scramble;
  }
  public boolean isScrambleAll () {
    return ScrambleAll;
  }
  public boolean isSwitchCheck () {
    return SwitchCheck;
  }
  public boolean isVerbose () {
    return Verbose;
  }
  public boolean isVersion () {
    return Version;
  }
  public boolean isPrintSearch () {
    return PrintSearch;
  }


  public OptionsSuperI Clone() throws CloneNotSupportedException {
    return (PizzaCompilerOptions) super.clone();
  }

  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    PizzaCompilerOptions NewPizza = (PizzaCompilerOptions) TheOtherOne;

    if (NewPizza.isExperimental () != isExperimental ())
      return true;
    if (NewPizza.isDebug () != isDebug())
      return true;
    if (NewPizza.isJavaOnly () != isJavaOnly())
      return true;
    if (NewPizza.isEmit () != isEmit())
      return true;
    if (NewPizza.isScramble () != isScramble())
      return true;
    if (NewPizza.isScrambleAll () != isScrambleAll())
      return true;
    if (NewPizza.isSwitchCheck () != isSwitchCheck())
      return true;
    if (NewPizza.isVerbose () != isVerbose())
      return true;
    if (NewPizza.isVersion () != isVersion())
      return true;
    if (NewPizza.isPrintSearch () != isPrintSearch())
      return true;
    return false;
  }

  public String getName() {
    return PizzaCompilerOptionsName;
  }

  public void setDefaults() {
    setExperimental (true);
    setDebug        (true);
    setJavaOnly     (false);
    setEmit         (false);
    setScramble     (false);
    setScrambleAll  (false);
    setSwitchCheck  (true);
    setVerbose      (false);
    setVersion      (true);
    setPrintSearch  (false);
  }

  public OptionsEvent PrepareEvent(int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }
}
