/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions;

import org.freebuilder.system.classes.options.*;
import java.util.EventObject;
import java.util.Vector;
import org.freebuilder.gui.beans.*;
       

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class PathsOptions implements OptionsSuperI, Cloneable {

  public static final String PathsOptionsName = "Paths Options";

  private String [] SourcePath;
  private String [] ClassPath;
  private String [] DocPath;
  private String ClassOutPath;
  private String PizzaSourceOutPath;
  private String JavaDOCOutPath;

  public String [] getDocPath () {
    return DocPath;
  }
  public String [] getClassPath () {
    return ClassPath;
  }
  public String [] getSourcePath () {
    return SourcePath;
  }
  public String getClassOutPath () {
    return ClassOutPath;
  }
  public String getJavaDOCOutPath () {
    return JavaDOCOutPath;
  }
  public String getPizzaSourceOutPath () {
    return PizzaSourceOutPath;
  }

  public void setDocPath (String [] NewDocPath) {
    DocPath = NewDocPath;
  }
  public void setClassPath (String [] NewClassPath) {
    ClassPath = NewClassPath;
  }
  public void setSourcePath (String [] NewSourcePath) {
    SourcePath = NewSourcePath;
  }
  public void setJavaDOCOutPath (String NewJavaDOCOutPath) {
    JavaDOCOutPath = NewJavaDOCOutPath;
  }
  public void setClassOutPath (String NewClassOutPath) {
    ClassOutPath = NewClassOutPath;
  }
  public void setPizzaSourceOutPath (String NewPizzaSourceOutPath) {
    PizzaSourceOutPath = NewPizzaSourceOutPath;
  }

// ================ OptionsSuperI implementation ================

  public OptionsSuperI Clone () throws CloneNotSupportedException {
    PathsOptions TheClone = new PathsOptions();
    TheClone.setPizzaSourceOutPath (new String (getPizzaSourceOutPath()));
    TheClone.setClassOutPath       (new String (getClassOutPath()));
    TheClone.setJavaDOCOutPath     (new String (getJavaDOCOutPath()));
    TheClone.setClassPath          (Misc.cloneStrArray (getClassPath()));
    TheClone.setSourcePath         (Misc.cloneStrArray (getSourcePath()));
    TheClone.setDocPath            (Misc.cloneStrArray (getDocPath()));
    return TheClone;
  }

  public void setDefaults () {
    setPizzaSourceOutPath ("");
    setClassOutPath       ("");
    setJavaDOCOutPath     ("");
    setClassPath          (new String [0]);
    setSourcePath         (new String [0]);
    setDocPath            (new String [0]);
  }

  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    PathsOptions Match = (PathsOptions) TheOtherOne;
    if (Match.getPizzaSourceOutPath().compareTo (getPizzaSourceOutPath()) != 0)
      return true;
    if (Match.getClassOutPath().compareTo (getClassOutPath()) != 0)
      return true;
    if (Match.getJavaDOCOutPath().compareTo (getJavaDOCOutPath()) != 0)
      return true;
    if (Match.getJavaDOCOutPath().compareTo (getJavaDOCOutPath()) != 0)
      return true;
    if (Misc.compareStrArray (Match.getClassPath(), getClassPath()))
      return true;
    if (Misc.compareStrArray (Match.getSourcePath(), getSourcePath()))
      return true;
    if (Misc.compareStrArray (Match.getDocPath(), getDocPath()))
      return true;

    return false;
  }

  public String getName() {
    return PathsOptionsName;
  }

  public OptionsEvent PrepareEvent(int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }
}
