/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions;

import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.projectman.*;
import org.freebuilder.system.ideengine.*;
import java.util.EventObject;
import java.util.Vector;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.config.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class CompilerOptions implements OptionsSuperI, Cloneable {

  public static final String CompilerManOptionsName = "Compiler Options";

  public static final int NO_DEBUG_INFO          = 0;
  public static final int LINE_NUMBERS_INFO_ONLY = 1;
  public static final int FULL_DEBUG_INFO        = 2;

  private boolean Deprecation;
  private boolean SpeedOptim;
  private boolean NoWarning;

  private boolean Verbose;
  private boolean Depend;

  private int DebugInfoFlags;

  private String OtherOptions;

  public String[] getOptions () {
    Vector Opts = new Vector();

    if (isDeprecation())
      Opts.addElement ("-deprecation");
    if (isNoWarning())
      Opts.addElement ("-nowarn");
    if (isVerbose())
      Opts.addElement ("-verbose");
    if (isDepend())
      Opts.addElement ("-depend");
    if (isSpeedOptim())
      Opts.addElement ("-O");

    switch (DebugInfoFlags) {
      case NO_DEBUG_INFO:
//        Opts.addElement ("-g:nodebug");
      break;
      case FULL_DEBUG_INFO:
        Opts.addElement ("-g");
      break;
    }

    PathsOptions POptions = (PathsOptions) Globals.Options.getOptions(PathsOptions.PathsOptionsName);

    if ((POptions.getClassOutPath() != null) && (POptions.getClassOutPath().length() > 0)) {
      Opts.addElement ("-d");
      Opts.addElement (POptions.getClassOutPath());
    }

    Opts.addElement ("-classpath");
    String TheClassPath = Globals.getProjectPath();
    TheClassPath += java.io.File.pathSeparator + PathEditorDialog.getPath(POptions.getSourcePath());
    TheClassPath += java.io.File.pathSeparator + PathEditorDialog.getPath(POptions.getClassPath());
    TheClassPath += java.io.File.pathSeparator + POptions.getClassOutPath();
    Opts.addElement (TheClassPath);
    String [] OtherOpts = Misc.getParamsArray (getOtherOptions());
    for (int i = 0; i < OtherOpts.length; i++) {
      OtherOpts[i] = "-J"+OtherOpts[i];
      Opts.addElement (OtherOpts[i]);
    }

    String [] Ret = new String [Opts.size()];
    Opts.copyInto (Ret);
    return Ret;
  }


  public boolean isDeprecation () {
    return Deprecation;
  }
  public void setDeprecation (boolean Deprecation) {
    this.Deprecation = Deprecation;
  }

  public boolean isSpeedOptim () {
    return SpeedOptim;
  }
  public void setSpeedOptim (boolean SpeedOptim) {
    this.SpeedOptim = SpeedOptim;
  }

  public boolean isNoWarning () {
    return NoWarning;
  }
  public void setNoWarning (boolean NoWarning) {
    this.NoWarning = NoWarning;
  }

  public boolean isVerbose () {
    return Verbose;
  }
  public void setVerbose (boolean Verbose) {
    this.Verbose = Verbose;
  }

  public boolean isDepend () {
    return Depend;
  }
  public void setDepend (boolean Depend) {
    this.Depend = Depend;
  }

  public int getDebugInfoFlags () {
    return DebugInfoFlags;
  }
  public void setDebugInfoFlags (int NewFlags) {
    if ((NewFlags != NO_DEBUG_INFO) &&
       (NewFlags != LINE_NUMBERS_INFO_ONLY) &&
       (NewFlags != FULL_DEBUG_INFO))
      return;
    DebugInfoFlags = NewFlags;
  }

  public String getOtherOptions () {
    return OtherOptions;
  }
  public void setOtherOptions (String OtherOptions) {
    this.OtherOptions = OtherOptions;
  }

//=================OptionsSuperI implmentation ===================

  public OptionsSuperI Clone() throws CloneNotSupportedException {
    CompilerOptions Ret = (CompilerOptions) this.clone();
    Ret.setOtherOptions (new String (getOtherOptions()));
    return Ret;
  }

  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    CompilerOptions CM = (CompilerOptions) TheOtherOne;

    if (CM.isDeprecation() != isDeprecation())
      return true;
    if (CM.isSpeedOptim()  != isSpeedOptim())
      return true;
    if (CM.isNoWarning()   != isNoWarning())
      return true;

    if (CM.isVerbose() != isVerbose())
      return true;
    if (CM.isDepend()  != isDepend())
      return true;

    if (CM.getDebugInfoFlags() != getDebugInfoFlags())
      return true;
    if (CM.getOtherOptions().compareTo (getOtherOptions()) != 0)
      return true;

    return false;
  }

  public String getName() {
    return CompilerManOptionsName;
  }

  public void setDefaults() {
    setDeprecation    (true);
    setSpeedOptim     (false);
    setNoWarning      (false);
    setDebugInfoFlags (FULL_DEBUG_INFO);
    setOtherOptions   ("");
  }

  public OptionsEvent PrepareEvent(int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }
}
