/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.config;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.projectman.*;
import org.freebuilder.system.classes.options.manager.*;
/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class PathsOptionsConfig implements ActionListener {
  private static final String EDIT_LABEL   = "Edit";
  private static final String BROWSE_LABEL = "Browse";

  private static final String EDIT_DOC_PATH_CMD              = "EditDocPath";
  private static final String EDIT_CLASS_PATH_CMD            = "EditClassPath";
  private static final String EDIT_SOURCE_PATH_CMD           = "EditSourcePath";
  private static final String BROWSE_CLASS_OUT_PATH_CMD      = "BrowseClassOutPath";
  private static final String BROWSE_JAVADOC_OUT_PATH_CMD    = "BrowseJavaDOCOutPath";
  private static final String BROWSE_PIZZASOURCEOUT_PATH_CMD = "BrowsePizzaSourceOutPath";

  private static ButtonGroup Compilers = new ButtonGroup();
  private static JRadioButton JavaCompiler  = new JRadioButton ("Use Java Compiler for Java files", false);
  private static JRadioButton PizzaCompiler = new JRadioButton ("Use Pizza Compiler for Java files", true);

  private static ButtonGroup RunWhat = new ButtonGroup();
  private static JRadioButton RunApplet      = new JRadioButton ("Run Applet", false);
  private static JRadioButton RunApplication = new JRadioButton ("Run Application", true);

  private static JPanel MiscPanel               = new JPanel ();
  private static JPanel AnotherMiscPanel        = new JPanel();

  private static BPanel MainPanel               = new BPanel ();
  private static BPanel UseCompilerPanel        = new BPanel ();
  private static BPanel RunWhatPanel            = new BPanel ();
  private static BPanel PathsPanel              = new BPanel ("Paths");
  private static BPanel DocPathPanel            = new BPanel ("Doc Path:");
  private static BPanel SourcePathPanel         = new BPanel ("Source Path:");
  private static BPanel ClassPathPanel          = new BPanel ("Class Path:");
  private static BPanel ClassOutPathPanel       = new BPanel ("Class Output Path:");
  private static BPanel JavaDOCOutPathPanel     = new BPanel ("JavaDOC Output Path:");
  private static BPanel DefaultRunnablePanel    = new BPanel ("Runnable class (fully qualitied name):");
  private static BPanel DefaultRunnableHTMLPanel= new BPanel ("Runnable HTML (fot applets):");
  private static BPanel PizzaSourceOutPathPanel = new BPanel ("Pizza Out Source Path:");

  private JButton EditDocPathButton              = new JButton (EDIT_LABEL);
  private JButton EditClassPathButton            = new JButton (EDIT_LABEL);
  private JButton EditSourcePathButton           = new JButton (EDIT_LABEL);
  private JButton BrowseClassOutPathButton       = new JButton (BROWSE_LABEL);
  private JButton BrowseJavaDOCOutPathButton     = new JButton (BROWSE_LABEL);
  private JButton BrowsePizzaSourceOutPathButton = new JButton (BROWSE_LABEL);

  private JTextField DocPath            = new JTextField();
  private JTextField Runnable           = new JTextField();
  private JTextField RunnableHTML       = new JTextField();
  private JTextField ClassPath          = new JTextField();
  private JTextField SourcePath         = new JTextField();
  private JTextField ClassOutPath       = new JTextField();
  private JTextField JavaDOCOutPath     = new JTextField();
  private JTextField PizzaSourceOutPath = new JTextField();

  public PathsOptionsConfig () {
    DocPathPanel            .removeAll();
    ClassPathPanel          .removeAll();
    SourcePathPanel         .removeAll();
    ClassOutPathPanel       .removeAll();
    JavaDOCOutPathPanel     .removeAll();
    DefaultRunnablePanel    .removeAll();
    PizzaSourceOutPathPanel .removeAll();
    DefaultRunnableHTMLPanel.removeAll();

    Compilers.add (JavaCompiler);
    Compilers.add (PizzaCompiler);

    RunWhat.add (RunApplet);
    RunWhat.add (RunApplication);

    DocPathPanel            .setLayout (new BorderLayout(5, 5));
    ClassPathPanel          .setLayout (new BorderLayout(5, 5));
    SourcePathPanel         .setLayout (new BorderLayout(5, 5));
    ClassOutPathPanel       .setLayout (new BorderLayout(5, 5));
    JavaDOCOutPathPanel     .setLayout (new BorderLayout(5, 5));
    DefaultRunnablePanel    .setLayout (new BorderLayout(5, 5));
    PizzaSourceOutPathPanel .setLayout (new BorderLayout(5, 5));
    DefaultRunnableHTMLPanel.setLayout (new BorderLayout(5, 5));

    DocPathPanel            .add (DocPath,            BorderLayout.CENTER);
    ClassPathPanel          .add (ClassPath,          BorderLayout.CENTER);
    SourcePathPanel         .add (SourcePath,         BorderLayout.CENTER);
    ClassOutPathPanel       .add (ClassOutPath,       BorderLayout.CENTER);
    JavaDOCOutPathPanel     .add (JavaDOCOutPath,     BorderLayout.CENTER);
    DefaultRunnablePanel    .add (Runnable,           BorderLayout.CENTER);
    PizzaSourceOutPathPanel .add (PizzaSourceOutPath, BorderLayout.CENTER);
    DefaultRunnableHTMLPanel.add (RunnableHTML,       BorderLayout.CENTER);

    DocPathPanel           .add (EditDocPathButton,             BorderLayout.EAST);
    ClassPathPanel         .add (EditClassPathButton,           BorderLayout.EAST);
    SourcePathPanel        .add (EditSourcePathButton,          BorderLayout.EAST);
    ClassOutPathPanel      .add (BrowseClassOutPathButton,      BorderLayout.EAST);
    JavaDOCOutPathPanel    .add (BrowseJavaDOCOutPathButton,    BorderLayout.EAST);
    PizzaSourceOutPathPanel.add (BrowsePizzaSourceOutPathButton,BorderLayout.EAST);

    EditDocPathButton             .addActionListener (this);
    EditClassPathButton           .addActionListener (this);
    EditSourcePathButton          .addActionListener (this);
    BrowseClassOutPathButton      .addActionListener (this);
    BrowseJavaDOCOutPathButton    .addActionListener (this);
    BrowsePizzaSourceOutPathButton.addActionListener (this);

    EditDocPathButton             .setActionCommand (EDIT_DOC_PATH_CMD);
    EditClassPathButton           .setActionCommand (EDIT_CLASS_PATH_CMD);
    EditSourcePathButton          .setActionCommand (EDIT_SOURCE_PATH_CMD);
    BrowseClassOutPathButton      .setActionCommand (BROWSE_CLASS_OUT_PATH_CMD);
    BrowseJavaDOCOutPathButton    .setActionCommand (BROWSE_JAVADOC_OUT_PATH_CMD);
    BrowsePizzaSourceOutPathButton.setActionCommand (BROWSE_PIZZASOURCEOUT_PATH_CMD);

    UseCompilerPanel.setLayout (new GridLayout (1, 2, 1, 1));
    UseCompilerPanel.add (PizzaCompiler);
    UseCompilerPanel.add (JavaCompiler);

    RunWhatPanel.setLayout (new GridLayout (1, 2, 1, 1));
    RunWhatPanel.add (RunApplet);
    RunWhatPanel.add (RunApplication);

    MiscPanel       .setLayout (new BorderLayout(3, 3));
    AnotherMiscPanel.setLayout (new BorderLayout());
    MainPanel       .setLayout (new BorderLayout());
    PathsPanel      .setLayout (new GridLayout (3, 2, 1, 1));
    setMainPanel();
    getOptions ();
  }

  private synchronized String [] editPaths (String [] Paths, JTextField GUI) {
    PathEditorDialog PathEditor = new PathEditorDialog(Globals.IdeMainFrame, Paths);
    PathEditor.setVisible(true);
    boolean IsConfirmed = PathEditor.isConfirmed();
    String SRet         = PathEditor.getPath();
    String [] Ret       = PathEditor.getPaths();
    PathEditor.dispose();

    if (IsConfirmed) {
      synchronized (GUI) {
        GUI.setText (SRet);
      }
      return Ret;
    }
    return Paths;
  }

  private void choosePath (JTextField GUI) {
    DirectoryChooser FileD = new DirectoryChooser (Globals.IdeMainFrame);
    FileD.setVisible (true);
    String NewDir = FileD.getDirectory();
    FileD.dispose ();
    if (NewDir != null)
      synchronized (GUI) {
        GUI.setText (NewDir);
      }  
  }

  public void actionPerformed (ActionEvent e) {
    String CMD = e.getActionCommand ();

    if (CMD.compareTo (EDIT_DOC_PATH_CMD)== 0) {
      editPaths (Misc.parsePath (DocPath.getText(), ';'), DocPath);
      return;
    }

    if (CMD.compareTo (EDIT_SOURCE_PATH_CMD)== 0) {
      editPaths (Misc.parsePath (SourcePath.getText(),';'), SourcePath);
      return;
    }

    if (CMD.compareTo (EDIT_CLASS_PATH_CMD)== 0) {
      editPaths (Misc.parsePath (ClassPath.getText(),';'), ClassPath);
      return;
    }

    if (CMD.compareTo (BROWSE_CLASS_OUT_PATH_CMD)== 0) {
      choosePath (ClassOutPath);
      return;
    }

    if (CMD.compareTo (BROWSE_PIZZASOURCEOUT_PATH_CMD)== 0) {
      choosePath (PizzaSourceOutPath);
      return;
    }
    if (CMD.compareTo (BROWSE_JAVADOC_OUT_PATH_CMD)== 0) {
      choosePath (JavaDOCOutPath);
      return;
    }
  }

  public void getOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    ProjectOptions NewOptions = (ProjectOptions) (AOptions.getOptions(ProjectOptions.cDefaultName));
    PathsOptions   NewPaths   = (PathsOptions)   (AOptions.getOptions(PathsOptions.PathsOptionsName));

    DocPath            .setText (PathEditorDialog.getPath(NewPaths.getDocPath()));
    Runnable           .setText (NewOptions.getRunnable());
    RunnableHTML       .setText (NewOptions.getRunnableHTML());
    ClassPath          .setText (PathEditorDialog.getPath(NewPaths.getClassPath()));
    SourcePath         .setText (PathEditorDialog.getPath(NewPaths.getSourcePath()));
    ClassOutPath       .setText (NewPaths.getClassOutPath());
    JavaDOCOutPath     .setText (NewPaths.getJavaDOCOutPath());
    PizzaSourceOutPath .setText (NewPaths.getPizzaSourceOutPath());
    PizzaCompiler      .setSelected (NewOptions.isUsePizzaCompiler());
    JavaCompiler       .setSelected (!NewOptions.isUsePizzaCompiler());
    RunApplet          .setSelected (NewOptions.getRunApplication() == 0);
    RunApplication     .setSelected (NewOptions.getRunApplication() == 1);
  }

  public void setOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    ProjectOptions NewOptions = (ProjectOptions) (AOptions.getOptions(ProjectOptions.cDefaultName));
    PathsOptions   NewPaths   = (PathsOptions)   (AOptions.getOptions(PathsOptions.PathsOptionsName));

    NewOptions.setRunnable           (Runnable.getText());
    NewOptions.setRunnableHTML       (RunnableHTML.getText());
    NewOptions.setUsePizzaCompiler   (PizzaCompiler.isSelected ());
    NewOptions.setRunApplication     (RunApplet.isSelected()?0:1);

    NewPaths.setDocPath            (Misc.parsePath(DocPath.getText(), ';'));
    NewPaths.setClassPath          (Misc.parsePath(ClassPath.getText(), ';'));
    NewPaths.setSourcePath         (Misc.parsePath(SourcePath.getText(), ';'));
    NewPaths.setClassOutPath       (ClassOutPath.getText());
    NewPaths.setJavaDOCOutPath     (JavaDOCOutPath.getText());
    NewPaths.setPizzaSourceOutPath (PizzaSourceOutPath.getText());

    AOptions.setOptions (NewOptions);
    AOptions.setOptions (NewPaths);
  }

  public static void setMainPanel() {
    MainPanel.removeAll();
    PathsPanel.removeAll();
    MiscPanel.removeAll();
    AnotherMiscPanel.removeAll();
    PathsPanel.add (DocPathPanel);
    PathsPanel.add (JavaDOCOutPathPanel);
    PathsPanel.add (ClassPathPanel);
    PathsPanel.add (ClassOutPathPanel);
    PathsPanel.add (SourcePathPanel);
    PathsPanel.add (PizzaSourceOutPathPanel);
    MiscPanel.add (PathsPanel, BorderLayout.NORTH);
    MiscPanel.add (DefaultRunnablePanel, BorderLayout.CENTER);
    MiscPanel.add (DefaultRunnableHTMLPanel, BorderLayout.SOUTH);
    MainPanel.add (MiscPanel, BorderLayout.NORTH);
    AnotherMiscPanel.add (RunWhatPanel, BorderLayout.NORTH);
    AnotherMiscPanel.add (UseCompilerPanel, BorderLayout.SOUTH);
    MainPanel.add (AnotherMiscPanel, BorderLayout.SOUTH);
  }

  public static void setEnabledPanel (BPanel APanel, boolean isEnabled) {
    int i;
    int Count = APanel.getComponentCount();
    for (i = 0; i < Count; i++) {
      Component CurrentComponent = APanel.getComponent(i);
      CurrentComponent.setEnabled(isEnabled);
      if (CurrentComponent instanceof JTextField)
        ((JTextField) CurrentComponent).setEditable(isEnabled);
    }
    APanel.setEnabled (isEnabled);
  }

  public static BPanel getMainPanel () {
    return MainPanel;
  }
  public static BPanel getDocPathPanel () {
    return DocPathPanel;
  }
  public static BPanel getSourcePathPanel () {
    return SourcePathPanel;
  }
  public static BPanel getClassPathPanel () {
    return ClassPathPanel;
  }
  public static BPanel getClassOutPathPanel () {
    return ClassOutPathPanel;
  }
  public static BPanel getJavaDOCOutPathPanel () {
    return JavaDOCOutPathPanel;
  }
  public static BPanel getDefaultRunnablePanel () {
    return DefaultRunnablePanel;
  }
  public static BPanel getPizzaSourceOutPathPanel () {
    return PizzaSourceOutPathPanel;
  }
  public static BPanel getDefaultRunnableHTMLPanel () {
    return DefaultRunnableHTMLPanel;
  }
}

