/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.config;

import java.io.*;

import java.beans.*;
import java.awt.*;
import java.awt.event.*;

import java.util.*;
import java.net.*;

import org.freebuilder.gui.ide.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.projectman.*;

import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.ideengine.*;

import com.sun.java.swing.*;
import com.sun.java.swing.tree.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.event.*;



/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class ConfigDialog extends JDialog implements ActionListener, WindowListener, ChangeListener {

  private String OK_CMD          = "OK";
  private String CANCEL_CMD      = "Cancel";

  private JTabbedPane Tabs       = new JTabbedPane();

  private BPanel ButtonsPanel    = new BPanel();
  private Button OKButton        = new Button (OK_CMD);
  private Button CancelButton    = new Button (CANCEL_CMD);

  protected Vector Configurators = new Vector();

  public ConfigDialog () {
    super (Globals.IdeMainFrame, "", true);
    addWindowListener (this);

    getContentPane().setLayout (new BorderLayout(5, 5));
    setSize (610, 450);
    setResizable (true);

    addTab( new CompilerOptionsPanel() );
    addTab( new PizzaOptionsPanel() );
    addTab( new ProjectOptionsConfig() );
    addTab( new DebuggerOptionsPanel() );
    addTab( new JavaDOCOptionsPanel() );
    addTab( new EditorOptionsPanel() );

    getContentPane().add (Tabs, BorderLayout.CENTER);

    ButtonsPanel.setLayout (new GridLayout (1, 2, 5, 5));
    ButtonsPanel.add (OKButton);
    ButtonsPanel.add (CancelButton);
    getContentPane().add (ButtonsPanel, BorderLayout.SOUTH);

    OKButton.addActionListener     (this);
    CancelButton.addActionListener (this);
    Tabs.addChangeListener         (this);
    stateChanged                   (null);

    Misc.hardCenter (this);
  }

  protected void addTab(Configurator c) {
    Configurators.addElement( c );
    Tabs.addTab ( c.toString(), c.getGUI() );
  }

  public void exitOK () {
    setNewOptions ();
    exitDialog();
  }

  public void exitDialog () {
    CancelButton.requestFocus();
    ((JFrame)getParent()).toFront();
    setVisible(false);
  }

  public void setNewOptions() {
    for (int i = 0; i < Configurators.size(); i++)
      ((Configurator) (Configurators.elementAt(i))).setOptions();
  }

//============WindowListener implementation=======================
  public void windowClosing (WindowEvent e) {
    exitDialog();
  }
  public void windowClosed      (WindowEvent e) {}
  public void windowOpened      (WindowEvent e) {}
  public void windowActivated   (WindowEvent e) {}
  public void windowDeactivated (WindowEvent e) {}
  public void windowIconified   (WindowEvent e) {}
  public void windowDeiconified (WindowEvent e) {}

//============ActionListener implementation=======================
  public void actionPerformed (ActionEvent e) {
    String CMD = e.getActionCommand ();
    if (CMD.compareTo(OK_CMD) == 0)
      exitOK();

    if (CMD.compareTo(CANCEL_CMD) == 0)
      exitDialog();
  }

  public void stateChanged (ChangeEvent e) {
    Configurator SelectedConfigurator = (Configurator) Configurators.elementAt (Tabs.getSelectedIndex());
    SelectedConfigurator.initGUI();
  }
}


