/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.beans;

import java.awt.*;
// ------------------------------------------------------------------------------
// Begin of XYLayout
// ------------------------------------------------------------------------------

/** Dummy implementation if LayoutManager
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class XYLayout implements LayoutManager {
  /** Does nothing*/
  public void addLayoutComponent(String name, Component comp) {}

  /** Does nothing*/
  public void removeLayoutComponent(Component comp) {}

  /** Returns Parent's preferred size.*/
  public Dimension preferredLayoutSize (Container parent) {
    return parent.getPreferredSize();
  }

  /** Parent's minimum size.*/
  public Dimension minimumLayoutSize (Container parent) {
    return parent.getMinimumSize();
  }

  /** Invalidates add the parent's components.*/
  public void layoutContainer(Container parent) {
    int CompCount = parent.getComponentCount();
    int i;
    for (i = 0; i < CompCount; i ++)
      parent.getComponent(i).invalidate();
  }
}

// ------------------------------------------------------------------------------
// End of XYLayout
// ------------------------------------------------------------------------------

