/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.beans;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.tree.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.events.*;
import org.freebuilder.system.packages.*;
import java.awt.*;
import java.util.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class PackageTreeRenderer extends BasicTreeCellRenderer {
  public static ImageIcon UnknownType   = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "UnknownFile.gif"));
  public static ImageIcon KnownType     = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "KnownFile.gif"));
  public static ImageIcon Package       = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Package.gif"));
  public static ImageIcon PackageRoot   = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "PackageRoot.gif"));
  public static ImageIcon Directory     = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Directory.gif"));
  public static ImageIcon DirectoryRoot = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "DirectoryRoot.gif"));
  public static ImageIcon ProjectFile   = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "ProjectFile.gif"));

  public Component getTreeCellRendererComponent (JTree TheTree,
                                                 Object Value,
                                                 boolean selected,
                                                 boolean expanded,
                                                 boolean leaf,
                                                 int row,
                                                 boolean hasFocus) {
    ProjectTreeNode TheItem = (ProjectTreeNode) Value;
    super.getTreeCellRendererComponent (TheTree, Value, selected, expanded, leaf, row, hasFocus);
    setIcon (TheItem.getIcon());
    return this;
  }
}


/**
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/
class ProjectTreeNode  implements TreeNode {
  private Vector Children = null;
  private TreeNode Parent;
  private PacketItemI Data;

  public ProjectTreeNode (TreeNode TheParent, PacketItemI TheData) {
    Parent = TheParent;
    Data   = TheData;
    if (Parent == null) {
      Children = new Vector();
      for (int i = 0; i < Globals.RootPaths.getCount(); i++) {
        PacketItemI CuttentData = (PacketItemI) Globals.RootPaths.getObject(i);
        if (CuttentData == null)
          continue;
        for (int j = 0; j < CuttentData.getPacketItemsCount(); j++)
          checkAndAdd(CuttentData.getPacketItemAt(j));
      }
    }
  }

  public ImageIcon getIcon () {
    if (Data == null)
      return PackageTreeRenderer.ProjectFile;
    if (Data.getPacketItemKind() == PacketItemI.cpikPacket)
      return PackageTreeRenderer.Package;
    else
      return PackageTreeRenderer.KnownType;
  }

  public String toString () {
    if (Data == null)
      return "System Paths";
    return Data.getFileName();
  }

  public Enumeration children() {
    if (Children == null)
      getChildCount();
    return Children.elements();
  }

  public boolean getAllowsChildren() {
    return true;
  }

  public TreeNode getChildAt (int Index) {
    if (Children == null)
      getChildCount();
    return (TreeNode) Children.elementAt (Index);
  }

  private void checkAndAdd (PacketItemI NewItem) {
    int i;
    if ((NewItem.getPacketItemKind() == PacketItemI.cpikPacket) ||
        (NewItem.getPacketItemKind() == PacketItemI.cpikSource))
 {
      for (i = 0;i < Children.size();i++) {
         ProjectTreeNode CurElem = (ProjectTreeNode) Children.elementAt(i);
         if (CurElem.toString().compareTo (NewItem.getFileName()) == 0)
           break;
      }
      if (i == Children.size())   
        Children.addElement (new ProjectTreeNode (this, NewItem));
    }
  }

  public int getChildCount() {
    if (Children == null) {
      Children = new Vector();
      int CountTo = Data.getPacketItemsCount();
      for (int i = 0; i < CountTo; i++)
        checkAndAdd(Data.getPacketItemAt(i));
    }
    return Children.size();
  }

  public int getIndex(TreeNode Child) {
    if (Children == null)
      getChildCount();
    return Children.indexOf (Child);
  }

  public TreeNode getParent() {
    return Parent;
  }

  public boolean isLeaf() {
    if (Data == null)
      return false;
    if (Data.getPacketItemKind() == PacketItemI.cpikPacket)
      return false;
    else
      return true;
  }

  public String getFullPackagePath () {
    if (Data == null)
      return "";
    return Data.getDotName();
  }

  public PacketItemI getData () {
    return Data;
  }
}

/**
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/
public class PackageChooser extends DirectoryChooser {
  public PackageChooser () {
    super(Globals.IdeMainFrame);
    setTitle ("Choose a package");
    TheFile.removeKeyListener (this);
    TheFile.setEditable (false);
    TheFile.setEnabled  (false);
  }

  public JTree prepareFilesTree () {
    return new JTree (new ProjectTreeNode (null, null));
  }

  public void setTree (JTree NewTree) {
    TheTree = NewTree;
    TheTree.setCellRenderer (new PackageTreeRenderer());
    adjustTree();
  }

  protected void onExit () {
    Object [] SelectedPath = TheTree.getSelectionPath().getPath();
    ProjectTreeNode SelectedNode = (ProjectTreeNode) SelectedPath [SelectedPath.length - 1];
    Directory = SelectedNode.getFullPackagePath();
/*
    if (SelectedNode.getData().getPacketItemKind() == PacketItemI.cpikPacket)
      Directory = SelectedNode.getFullPackagePath();
    else
      if (SelectedNode.getParent().getParent() == null)
        Directory = null;
      else
        Directory = ((ProjectTreeNode)SelectedNode.getParent()).getFullPackagePath();
*/
  }

  protected void setText (Object[] Path) {
    ProjectTreeNode SelectedNode = (ProjectTreeNode) Path [Path.length - 1];
    TheFile.setText(SelectedNode.getFullPackagePath());
  }
}
