/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.beans;

import java.awt.image.*;
import java.awt.event.*;
import java.awt.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.ideengine.*;
import java.util.*;
import com.sun.java.swing.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 07-01-98
*/
class HintWindow extends Window {
  String Hint;

  public HintWindow (Frame Parent, String Hint) {
    super(Parent);
    this.Hint = Hint;
    setBackground (Color.white);
  }

  public void paint (Graphics g) {
    FontMetrics FM = g.getFontMetrics();
    int Height = FM.getHeight() + 2;
    int Width = FM.stringWidth(Hint) + 10;


    Dimension SS = getToolkit().getScreenSize();
    Point L = getLocation();

    setSize (Width, Height);
    if (L.x + Width > SS.width)
      setLocation (SS.width - Width, L.y);
    g.setColor (Color.black);
    g.drawString (Hint , 5 , Height - 4);
    g.drawRect (0, 0, getSize().width - 1, getSize().height - 1);
  }
}

/**
  *  @author	Peter Radkov <wreck@nat.bg>
  *  @version 0.7, 07-01-98
*/
class HintThread extends java.lang.Thread {
  private Point HintLoc;
  private static HintWindow HintWindow;
  private int Counter = 0;

  public HintThread (String Hint, Point P) {
    if (HintWindow != null)
      HintWindow.dispose();
    HintWindow = new HintWindow (Globals.IdeMainFrame, Hint);
    HintLoc = P;
    setPriority (Thread.MIN_PRIORITY);
  }

  public synchronized void run () {
    while (true) {
      try {wait (1000);}
      catch (InterruptedException e) {
       continue;
      }

      HintWindow.setLocation (HintLoc.x, HintLoc.y + 20);
      HintWindow.setSize (1,1);
      HintWindow.setVisible (true);

      try { wait (5000); }
      catch (InterruptedException e) {}
      HintWindow.setVisible (false);
      try {wait ();}
      catch (InterruptedException e) {}
    }
  }

  public void closeHint () {
    HintWindow.dispose();
    stop();
  }

  public void resetHint (Point P) {
    HintLoc = P;
    this.interrupt();
  }
}

// ------------------------------------------------------------------------------
// Begin of IconCanvas
// ------------------------------------------------------------------------------

/**
  This class represents an Cnavas with an image in it.
  It implements almost all of the functionality of a button.
  *  @author	Peter Radkov <wreck@nat.bg>
  *  @version 0.7, 07-01-98
*/

public class IconCanvas extends JComponent implements MouseListener, MouseMotionListener {
  private Vector Listeners = new Vector();

  /** The width of the icon. */
  protected int IconWidth  = 36;

  /** The height of the icon. */
  protected int IconHeight = 36;

  /** If this icon is selected. */
  protected boolean Selected    = false;
  protected boolean Disabled    = false;
  protected int RealImagePos = 0;
  protected int States = 1;

  /** The image, that will be displayed. */
  protected Image Bean;
  private static HintThread HT;
  private String IconHint = null;

  /** The number of this icon.*/
  protected int No;

  protected boolean IsMouseInside      = false;

  /** Initializes the object. */
  public IconCanvas (Image Bean, int No, int States) {
    this (Bean, No);
    this.States = States;
  }
  /** Initializes the object. */
  public IconCanvas (Image Bean, int No) {
    super();
    this.Bean = Bean;
    this.No = No;
    setBounds (0, No * IconHeight, IconWidth, IconHeight);
    setBackground (Color.lightGray);
    addMouseListener (this);
    addMouseMotionListener (this);
  }

  /** Paints this icon, depending on if it is selected or no. */
  public void paint (Graphics g) {
    int Correction;
    if (g == null)
      return;

    if (Selected)
      Correction = 1;
    else
      Correction = 0;

    Rectangle CB = g.getClipBounds();

    int Cx = CB.x > 2+Correction ? CB.x : 2+Correction;
    int Cy = CB.y > 2+Correction ? CB.y : 2+Correction;
    int Cw = CB.width < IconWidth - 4 ? CB.width    : IconWidth - 4;
    int Ch = CB.height < IconHeight - 4 ? CB.height : IconHeight - 4;;

    g.setClip (Cx, Cy, Cw, Ch);

    g.drawImage (Bean, 2 - RealImagePos + Correction, 2 + Correction,
                       States * (IconWidth - 4), IconHeight - 4, this);

    g.setClip (CB);

    if (Selected)
      g.setColor (Color.black);
    else
      g.setColor (Color.white);

    g.drawLine (0, 0, 0, IconHeight - 1);
    g.drawLine (0, 0, IconWidth - 1, 0);

    if (Selected)
      g.setColor (Color.white);
    else
      g.setColor (Color.black);

    g.drawLine (IconWidth - 1, IconHeight - 1, IconWidth - 1, 0);
    g.drawLine (IconWidth - 1, IconHeight - 1, 0, IconHeight - 1);
  }

  /** Selects this icon. */
  public void select () {
    Selected = true;
    if (isShowing())
      repaint();
  }

  /** Deselects this icon. */
  public void deselect () {
    Selected = false;
    if (isShowing())
      repaint();
  }

  /** Does nothing. */
  public void mouseClicked (MouseEvent e) {
    if (HT != null) {
      HT.closeHint ();
      HT = null;
    }
  }

  /** Does nothing. */
  public void mouseReleased (MouseEvent e) {}

  /** Does nothing. */
  public void mouseEntered (MouseEvent e) {
    if (!isShowing())
      return;
    IsMouseInside = true;

    if (HT != null) {
      HT.closeHint ();
      HT = null;
    }

    if (IconHint != null) {
      HT = new HintThread (IconHint, e.getPoint());
      HT.start();
      try {
        Point CompLoc = getLocationOnScreen();
        e.translatePoint (CompLoc.x, CompLoc.y);
        HT.resetHint (e.getPoint());
      }
      catch (IllegalComponentStateException CompStateEx) {
      }
    }
  }

  /** Does nothing. */
  public void mouseExited (MouseEvent e) {
    IsMouseInside = false;
    if (HT != null) {
      HT.closeHint ();
      HT = null;
    }
  }

  /**
    Notifies the owner IconsPanel, that this icon should
    be selected.
  */
  public void mousePressed (MouseEvent e) {
    if (!Disabled)
      notifyListeners();
  }

  /**
    Sets the new size of the canvas. The image is resized
    appropriatly.
  */
  public void setSize (int Width, int Height) {
    super.setSize (Width, Height);
    IconWidth = Width;
    IconHeight = Height;
    if (isShowing())
      repaint();
  }

  /**
    Returns true if the canvas is pressed (the button is down).
  */
  public boolean isSelected () {
    return Selected;
  }

  /**
    MouseMotionListener implementation. This methods sold be called
    by the descendents, overrinding them in order to show the hint.
  */
  public void mouseMoved (MouseEvent e) {
    if (!isShowing())
      return;
    if (HT != null) {
      Point CompLoc = getLocationOnScreen();
      e.translatePoint (CompLoc.x, CompLoc.y);
      HT.resetHint (e.getPoint());
    }
  }

  /**
    MouseMotionListener implementation. This methods sold be called
    by the descendents, overrinding them in order to show the hint.
  */
  public void mouseDragged (MouseEvent e) {
    if (!isShowing())
      return;
    if (HT != null) {
      Point CompLoc = getLocationOnScreen();
      e.translatePoint (CompLoc.x, CompLoc.y);
      HT.resetHint (e.getPoint());
    }
  }

  /** Sets the hint string */
  public void setHint (String Hint) {
    IconHint = Hint;
  }

  /** Sets the state of the image, if it has "disabled" state. */
  public void setEnabled (boolean isEnabled) {
    Disabled = !isEnabled;
    if ((Disabled) && (States > 1))
      RealImagePos = IconWidth - 4;
    else {
      if ((!Disabled) && (States > 2) && (IsMouseInside))
        RealImagePos = (IconWidth - 4) * 2;
      else
        RealImagePos = 0;
    }
    if (isShowing())
      repaint();
  }

  public void addIconCanvasListener (IconCanvasListener NewListener) {
    Listeners.addElement(NewListener);
  }
  public void removeIconCanvasListener (IconCanvasListener OldListener) {
    Listeners.removeElement (OldListener);
  }
  private void notifyListeners () {
    int i;
    for (i = 0; i < Listeners.size(); i++)
      ((IconCanvasListener) Listeners.elementAt (i)).select(No);
  }
  public Dimension getPreferredSize () {
    return new Dimension (IconWidth, IconHeight);
  }
}

// ------------------------------------------------------------------------------
// End of IconCanvas
// ------------------------------------------------------------------------------

