/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

import org.freebuilder.system.ideengine.*;
import org.freebuilder.gui.beans.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 07-01-98
*/
class Closer extends Thread {
  AboutWindow Parent;
  public Closer (AboutWindow Parent) {
    this.Parent = Parent;
  }

  public synchronized void run () {
    try {wait (5000);}
    catch (InterruptedException e) {}
    Parent.setVisible(false);
    Parent.dispose();
  }
}

/**
  * @author	Peter Radkov <wreck@nat.bg>
  * @version 1.00, 26-01-97
*/
class AboutPanel extends BPanel implements MouseListener {
  private static int TheWidth = -1;
  private static int TheHeight= -1;
  private Image I1;
  private AboutWindow Parent;
  private Insets Ins;

  public AboutPanel (AboutWindow Parent, String ImageFile) {
    this.Parent = Parent;
    I1 = Globals.ResourceMngr.loadImage (Globals.IconsDir + ImageFile);
    prepareImage (I1, this);
    TheWidth = I1.getWidth(this);
    TheHeight = I1.getHeight(this);

    waitWileLoadingImage ();

    setBorderWidth (2);
    Ins = getInsets();
    setSize (TheWidth + Ins.left + Ins.right, TheHeight + Ins.top + Ins.bottom);
    addMouseListener (this);
  }

  private synchronized void waitWileLoadingImage () {
    while ((TheWidth <= 0) || (TheHeight <= 0))
      try {wait (10);}
      catch (InterruptedException e) {}
  }

  public void mouseExited   (MouseEvent e) {}
  public void mouseEntered  (MouseEvent e) {}
  public void mouseClicked  (MouseEvent e) {}
  public void mouseReleased (MouseEvent e) {}
  public void mousePressed  (MouseEvent e) {
    Parent.setVisible(false);
    Parent.dispose ();
  }

  public void paint (Graphics g) {
    super.paint(g);
    g.drawImage (I1, Ins.left, Ins.top, this);
    Closer CloseTimer = new Closer (Parent);
    CloseTimer.start();
  }

  public boolean imageUpdate (Image I, int InfoFlags, int x, int y, int Width, int Height) {
    boolean Ret = super.imageUpdate(I, InfoFlags, x, y, Width, Height);
    if (((InfoFlags&PROPERTIES) != 0) || ((InfoFlags&ALLBITS) != 0)) {
      TheWidth  = I1.getWidth  (this) ;
      TheHeight = I1.getHeight (this);
    }
    return Ret;
  }
}

/**
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/
class AboutWindow extends Window {
  public static boolean IsVisible = false;
  public AboutWindow (Frame ParentFrame, String ImageTitle) {
    super (ParentFrame);
    AboutPanel AP = new AboutPanel (this, ImageTitle);
    setLayout (new BorderLayout());
    add (AP);
    setSize (AP.getSize());
    Misc.hardCenter (this);
  }

  public void setVisible (boolean Visible) {
    IsVisible = Visible;
    super.setVisible(Visible);
  }
}

