/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.wizards;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.idemenu.*;
import org.freebuilder.system.packages.*;
import org.freebuilder.system.ideengine.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
/** The Application Wizard.*/
public class ApplicationWizard extends JDialog implements ActionListener, WindowListener {
  private static final String OK_CMD     = "OK";
  private static final String CANCEL_CMD = "Cancel";

  private boolean Confirmed   = false;
  private Button OKButton     = new Button (OK_CMD);
  private Button CancelButton = new Button (CANCEL_CMD);

  private BPanel ButtonsPanel             = new BPanel ();
  private ClassPathAndNamePanel DataPanel = new ClassPathAndNamePanel ("Application");

  public ApplicationWizard () {
    super (Globals.IdeMainFrame, "Application Wizard", true);

    if (!Globals.PManager.isOpenedProject()) {
      MainMenuEvent TheEvent = new MainMenuEvent (IdeMainMenu.msgmiProjectNew, this);
      Globals.EventsEngine.SendEvent (TheEvent);
      if (TheEvent.Result != 0)
        return;
    }

    setDefaultCloseOperation (DO_NOTHING_ON_CLOSE);
    addWindowListener (this);

    ButtonsPanel.setLayout (new GridLayout (1, 2, 5, 5));
    ButtonsPanel.add (OKButton);
    ButtonsPanel.add (CancelButton);

    getContentPane().setLayout (new BorderLayout());
    getContentPane().add (DataPanel,    BorderLayout.NORTH);
    getContentPane().add (ButtonsPanel, BorderLayout.SOUTH);

    OKButton.addActionListener (this);
    CancelButton.addActionListener (this);

    Dimension ScreenSize = getToolkit().getScreenSize();
    pack();
    setSize (ScreenSize.width * 2 / 5, getSize().height);
    Misc.hardCenter (this);
  }

  /** Automatically generates the minimal the application code. */
  private void autoGen (PrintWriter Printer) {
    Printer.println ("/*FreeBuilder Application Generator*/");
    Printer.println ();
    Printer.println ("package " + DataPanel.getPackage() + ";");
    Printer.println ();
    Printer.println ();
    Printer.println ("public class " + DataPanel.getClassName() + " {");
    Printer.println ("  public static void main (String [] args) {");
    Printer.println ("  }");
    Printer.println ("}");
  }

  /** Saves the newly generated file and adds it to the project.*/
  public void createFile () {
    String FileName = DataPanel.getFileName();
    int i = 0;
    int Count = Globals.PItems.getCount();
    for (i = 0; i < Count; i++) {
      PacketItemI CurPItem = Globals.PItems.getPacketItem(i);
      if (CurPItem == null)
        continue;
      if (FileName.equalsIgnoreCase(CurPItem.getFullDosPath()))
        break;
    }
    if (i == Count)
      Globals.PManager .addFile (FileName);

    StringWriter AutoGen = new StringWriter ();
    PrintWriter Printer = new PrintWriter (AutoGen);
    autoGen (Printer);
    String Text = AutoGen.getBuffer().toString();
    Globals.TextFiles.openFile(FileName, new StringReader (Text), Text.length());
    while (!Globals.TextFiles.saveActiveFile()) {
      if (Misc.messageBox (new String [] {"Retry", "Ignore"}, new String [] {"Unable to save "+ FileName}, 1) != 0)
        break;
    }
  }

  public void actionPerformed (ActionEvent e) {
    String CMD = e.getActionCommand();
    if (OK_CMD.compareTo (CMD) == 0) {
      if (!DataPanel.checkValidity())
        return;
      Confirmed = true;
    }


    if (CANCEL_CMD.compareTo (CMD) == 0)
      Confirmed = false;
    setVisible (false);
  }

  public boolean isConfirmed () {
    return Confirmed;
  }

  public void windowClosed (WindowEvent e) {}
  public void windowIconified (WindowEvent e) {}
  public void windowDeiconified (WindowEvent e) {}
  public void windowActivated (WindowEvent e) {}
  public void windowDeactivated (WindowEvent e) {}
  public void windowOpened (WindowEvent e) {}
  public void windowClosing (WindowEvent e) {
    Confirmed = false;
    CancelButton.requestFocus();
    setVisible(false);
  }
}
