/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.options.manager;

import java.lang.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.events.engine.IdeEventsEngine;

/** The class <code>DefaultOptions</code> is responsible for managing default "hard-coded"
  * options. Made it via overriding CreateDefaultConfig method. MainConfig and ProjectConfig
  * classes inherite from this one. So, they have the same default configuration, but any
  * of them can change this situation overriding CreateDefaultConfig() method.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class DefaultOptions extends OptionsColl {
  private transient CreateDOptionsListener CreateDOptionsObject = null;

  public DefaultOptions(IdeEventsEngine AEventsEngine, String AConfigFileName, CreateDOptionsListener DOptionsCreateObject) {
    super(AEventsEngine, AConfigFileName);
    setDOptionsListener(DOptionsCreateObject);
  }

  /** Put here all the options which have to exist on startup */
  public void CreateDefaultConfig() {
    if (CreateDOptionsObject == null) return;
    CreateDOptionsObject.CreateDefaultConfig(this);
  }

  public void setDOptionsListener(CreateDOptionsListener ACreateDOptionsObject) {
    CreateDOptionsObject = ACreateDOptionsObject;
  }
}
