/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events.engine;

import java.util.EventObject;


/** Abstract class <code>IdeEventListenerAC</code> implements IdeEventListenerI and fills in it's methods.
  * It is a the root class to descent from for creating a hierarchy of listeners.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public abstract class IdeEventListenerAC implements IdeEventListenerI {
  int     CallMask;      /** bit mask for calling BeforeAction, OnAction and AfterAction methods */
  Class   EventsClass;   /** Which event class will handle */
  boolean Enabled;       /** if true Dispatch messages */

  /** @param  ACallMask - bit mask paramether. when dispatching the message the following is true
    * if bit 0 = 1 call BeforeAction
    * if bit 1 = 1 call OnAction
    * if bit 2 = 1 call AfterAction
  */
  public IdeEventListenerAC(int ACallMask) {
    Enabled     = true;
    CallMask    = ACallMask;
    EventsClass = PrepareEventsClass();
  }

  /** @return EventClass which this listener will accept */
  public Class getEventsClass() {
    return EventsClass;
  }

  /** @return prepeare and instance of the Event that listener will accept and returns it's Class
    * Override this function for every new class of events.
  */
  protected Class PrepareEventsClass() {
    EventObject Event = new EventObject(null);
    return Event.getClass();
  }

  /** @return true if shall call BeforeAction function for this listener. see the constructor */
  public boolean ShallCallBefore() { return (CallMask & BEFORE_CALL_MASK) != 0; }

  /** @return true if shall call OnAction function for this listener. see the constructor  */
  public boolean ShallCall()       { return (CallMask & CALL_MASK)        != 0; }

  /** @return true if shall call AfterAction function for this listener. see the constructor  */
  public boolean ShallCallAfter()  { return (CallMask & AFTER_CALL_MASK)  != 0; }

  public void BeforeAction(IdeSuperEvent AEvent) {}
  public void OnAction    (IdeSuperEvent AEvent) {}
  public void AfterAction (IdeSuperEvent AEvent) {}

  /** @return true - if this listener will accept sublclases of this event class returned by getEventsClass too */
  public boolean isChildEventsListener()         { return false; }

  /** @return true - if the listener will handle the event */
  public boolean AcceptEvent(IdeSuperEvent AEvent) {
    return false;
  }

  /** Enable, or disable handling the events for this listener. Before removing EventEngine object calls this
    * method with AEnable = false, to disable handling of other events */
  public void setIdeEventLEnable(boolean AEnable) {
    if (AEnable == Enabled) return;
    Enabled = AEnable;
  }

  /** return true if handling the events are enabled. When dispatching the events this method is called
    * by IdeEventsListItem to deside if have to deliver the Event to this listener */
  public boolean isIdeEventLEnabled() { return Enabled; }
}


