/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions.abstr;
import java.util.*;

/**
  An abstract class, that implements the functions for
  adding, removing, etc. its items around.
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class ItemMan implements java.io.Serializable {
  /** The Items are stored here. */
  private Vector Items = null;

  /** Initializes the object. */
  protected ItemMan () {
    Items = new Vector();
  }

  /**
    Returns the name of the specified Item.
    Simply calls the <code>SipleItem.getName()</code>.
  */
  private final String getItemName (SimpleItem Item) {
    return Item.getName();
  }

  /** Returns the number of stored items. */
  protected final int getItemsCount () {
    return Items.size();
  }

  /** Adds a new Item. Duplicate items are allowed. */
  protected final void addItem (SimpleItem NewItem) {
    Items.addElement (NewItem);
  }

  /**
    Returns the Item at the specified position or null, if
    the position is invalid.
  */
  protected final SimpleItem getItem (int ItemNo) {
    if ((ItemNo < 0) || (ItemNo >= getItemsCount()))
      return null;
    return (SimpleItem) Items.elementAt (ItemNo);
  }

  /**
    Returns the first occurance of the Item woth the specified name, or
    null, if no such Item exists.
  */
  protected final SimpleItem getItem (String ItemName) {
    int ItemsCount = getItemsCount();
    int j;

    for (j=0;j<ItemsCount;j++) {
      SimpleItem CurrentItem = getItem(j);
      if (ItemName.equals (getItemName (CurrentItem)))
        return CurrentItem;
    }
    return null;
  }

  /**
    Removes the Item from the Specified position.
    If the position is invalid, does nothing.
  */
  protected final void removeItem (int ItemNo) {
    if ((ItemNo < 0) || (ItemNo >= getItemsCount()))
      return;
    Items.removeElementAt (ItemNo);
  }

  /**
    Removes the first occurance of the Item with the specified name.
    If no such Item exists, does nothing.
  */
  protected final void removeItem (String ItemName) {
    removeItem (getItem(ItemName));
  }

  /** Removes the specified Item. */
  protected final void removeItem (SimpleItem Item) {
    if (Item != null)
      Items.removeElement (Item);
  }

  /**
    Moves the Item from the SourcePos to DestPos.
    If either of the arguments is an invalid posistion, does nothing.
  */
  protected final void moveItem (int SourcePos, int DestPos) {
    SimpleItem Item;
    if ((SourcePos < 0) || (SourcePos >= getItemsCount()) ||
        (DestPos < 0) || (DestPos >= getItemsCount()))
      return;
    Item = getItem (SourcePos);
    Items.removeElement (Item);
    Items.insertElementAt (Item, DestPos);
  }

  protected final void removeAll () {
    Items.removeAllElements(); 
  }

  public Vector getItems() {
    return Items;
  }
}
