/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions;

import org.freebuilder.gui.config.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.events.*;

import org.freebuilder.gui.beans.*;

import java.util.*;
import java.awt.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class EditorOptions implements OptionsSuperI, Cloneable {
  public static final String EditorOptionsName = "Editor Options";

  private String fontName;
  private int fontStyle;
  private int fontSize;
  
  private Color bgColor;
  private Color fgColor;

  public String getFontName () {
    return fontName;
  }
  public void setFontName (String inFontName) {
    fontName = inFontName;
  }

  public int getFontStyle () {
    return fontStyle;
  }
  public void setFontStyle (int inFontStyle) {
    fontStyle = inFontStyle;
  }

  public int getFontSize () {
    return fontSize;
  }
  public void setFontSize (int inFontSize) {
    fontSize = inFontSize;
  }

  public Color getFGColor () {
    return fgColor;
  }
  public void setFGColor (Color inFGColor) {
    fgColor = inFGColor;
  }

  public Color getBGColor () {
    return bgColor;
  }
  public void setBGColor (Color inBGColor) {
    bgColor = inBGColor;
  }
  public OptionsSuperI Clone() throws CloneNotSupportedException {
    EditorOptions ClonedOptions = (EditorOptions) clone();
    return ClonedOptions;
  }

  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    EditorOptions Other = (EditorOptions) TheOtherOne;
    if (Other.getFontName ()  != getFontName ())
      return true;
    if (Other.getFontStyle () != getFontStyle ())
      return true;
    if (Other.getFontSize ()  != getFontSize ())
      return true;
    if (!Other.getBGColor().equals(getBGColor()))
      return true;
    if (!Other.getFGColor().equals(getFGColor()))
      return true;

    return false;
  }

  public String getName() {
    return EditorOptionsName;
  }

  public void setDefaults() {
    setFontName          ("TimesRoman");
    setFontStyle         (Font.BOLD);
    setFontSize          (16);
    setBGColor           (Color.white);
    setFGColor           (Color.black);
  }

  public OptionsEvent PrepareEvent(int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }

}
