/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.idemenu;

import java.awt.*;
import java.awt.event.*;
import java.awt.MenuShortcut;
import java.util.EventObject;
import org.freebuilder.system.classes.events.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.ideengine.*;

import com.sun.java.swing.*;  // Delte this

/** Class <code>MainMenuEvent</code>. is the Event kind whick MenuItems will send.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 07-01-98 */

public class IdeMainMenu extends IdeMenuBar {
  public static final int msgmFile                    = MainMenuEvent.mmsgFirstMnuMsg;
  public static final int msgmOpen                    = msgmFile                    + 1;
  public static final int msgmEdit                    = msgmOpen                    + 1;
  public static final int msgmSearch                  = msgmEdit                    + 1;
  public static final int msgmView                    = msgmSearch                  + 1;
  public static final int msgmProject                 = msgmView                    + 1;
  public static final int msgmBuild                   = msgmView                    + 1;
  public static final int msgmRun                     = msgmBuild                   + 1;
  public static final int msgmWizards                 = msgmRun                     + 1;
  public static final int msgmTools                   = msgmWizards                 + 1;
  public static final int msgmHelp                    = msgmTools                   + 1;

  public static final int msgmiFileNew                = msgmHelp                    + 1;
  public static final int msgmiFileOpen               = msgmiFileNew                + 1;
  public static final int msgmiFileReopen             = msgmiFileOpen               + 1;
  public static final int msgmiOpenPackage            = msgmiFileReopen             + 1;
  public static final int msgmiOpenPackageTree        = msgmiOpenPackage            + 1;
  public static final int msgmiOpenDirectory          = msgmiOpenPackageTree        + 1;
  public static final int msgmiOpenDirTree            = msgmiOpenDirectory          + 1;
  public static final int msgmiFileSave               = msgmiOpenDirTree            + 1;
  public static final int msgmiFileSaveAs             = msgmiFileSave               + 1;
  public static final int msgmiFileSaveAll            = msgmiFileSaveAs             + 1;
  public static final int msgmiFileClose              = msgmiFileSaveAll            + 1;
  public static final int msgmiFileCloseAll           = msgmiFileClose              + 1;
  public static final int msgmiFileRemoveFromProject  = msgmiFileCloseAll           + 1;
  public static final int msgmiFileRename             = msgmiFileRemoveFromProject  + 1;
  public static final int msgmiFilePrinterSetup       = msgmiFileRename             + 1;
  public static final int msgmiFilePrint              = msgmiFilePrinterSetup       + 1;
  public static final int msgmiFileExit               = msgmiFilePrint              + 1;

  public static final int msgmiEditUndo               = msgmiFileExit               + 1;
  public static final int msgmiEditRedo               = msgmiEditUndo               + 1;
  public static final int msgmiEditCut                = msgmiEditRedo               + 1;
  public static final int msgmiEditCopy               = msgmiEditCut                + 1;
  public static final int msgmiEditPaste              = msgmiEditCopy               + 1;
  public static final int msgmiEditDelete             = msgmiEditPaste              + 1;
  public static final int msgmiEditSelectAll          = msgmiEditDelete             + 1;

  public static final int msgmiSearchFind             = msgmiEditSelectAll          + 1;
  public static final int msgmiSearchReplace          = msgmiSearchFind             + 1;
  public static final int msgmiSearchFindAgain        = msgmiSearchReplace          + 1;
  public static final int msgmiSearchGoToLineNumber   = msgmiSearchFindAgain        + 1;
  public static final int msgmiSearchBrowse           = msgmiSearchGoToLineNumber   + 1;

  public static final int msgmiBuildMakeProject       = msgmiSearchBrowse           + 1;
  public static final int msgmiBuildRebuildProject    = msgmiBuildMakeProject       + 1;
  public static final int msgmiBuildMake              = msgmiBuildRebuildProject    + 1;
  public static final int msgmiBuildRebuild           = msgmiBuildMake              + 1;

  public static final int msgmiRunRun                 = msgmiBuildRebuild           + 1;
  public static final int msgmiRunDebug               = msgmiRunRun                 + 1;

  public static final int msgmiWizardsAppletWizard     = msgmiRunDebug              + 1;
  public static final int msgmiWizardsApplicationWizard= msgmiWizardsAppletWizard   + 1;

  public static final int msgmiToolsEnviromentOptions = msgmiWizardsApplicationWizard + 1;
  public static final int msgmiToolsConfigurePalette  = msgmiToolsEnviromentOptions   + 1;

  public static final int msgmiHelpAbout              = msgmiToolsConfigurePalette    + 1;

  public static final int msgmiViewOutput             = msgmiHelpAbout              + 1;
  public static final int msgmiViewDebugger           = msgmiViewOutput             + 1;

  public static final int msgmiProjectNew               = msgmiViewDebugger         + 1;
  public static final int msgmiProjectOpenCreate        = msgmiProjectNew           + 1;
  public static final int msgmiProjectClose             = msgmiProjectOpenCreate    + 1;
  public static final int msgmiProjectRemoveFromProject = msgmiProjectClose         + 1;
  public static final int msgmiProjectSave              = msgmiProjectRemoveFromProject+ 1;
  public static final int msgmiProjectSaveAs            = msgmiProjectSave          + 1;
  public static final int msgmiProjectRename            = msgmiProjectSaveAs        + 1;
  public static final int msgmiProjectProperties        = msgmiProjectRename        + 1;
  public static final int msgmiProjectStore             = msgmiProjectProperties    + 1;
  public static final int msgmiProjectDocumentation     = msgmiProjectStore         + 1;
  public static final int LastMainMenuMgsNo             = msgmiProjectDocumentation + 1;

  IdeMenu mnuFile;
  IdeMenu mnuEdit;
  IdeMenu mnuSearch;
  IdeMenu mnuView;
  IdeMenu mnuProject;
  IdeMenu mnuBuild;
  IdeMenu mnuRun;
  IdeMenu mnuWizards;
  IdeMenu mnuTools;
  IdeMenu mnuHelp;

  public IdeMainMenu() {
    Init();
  }

  protected IdeMenu AddSubmenuTo(IdeMenu AMenu, int Message, String label) {
    IdeMenu TheSubMenu = new IdeMenu (Message);
    TheSubMenu.setText(label);
    TheSubMenu.addMenuListener (TheSubMenu);
    AMenu.add  (TheSubMenu);
    return TheSubMenu;
  }

  protected IdeMenuItem AddMItemTo(IdeMenu AMenu, int Message, String label, boolean SetDefEnDis, MenuShortcut ShortC) {
    IdeMenuItem IMenuItem;
    if (ShortC != null)
      IMenuItem = new IdeMenuItem(Message, label, ShortC);
    else
      IMenuItem = new IdeMenuItem(Message, label);

    AMenu.add(IMenuItem);
//    IMenuItem.setFont(getFont()); (Ne bachka kak trebe pri Reopen)
//    if (SetDefEnDis) IMenuItem.setCheckStatusListener(IMenuItem);
    return IMenuItem;
  }

  protected QueryEnDisMenuItem AddMItemTo(IdeMenu AMenu, int Message, int QueryCmd, String label, MenuShortcut ShortC) {
    QueryEnDisMenuItem IMenuItem;
    if (ShortC != null)
      IMenuItem = new QueryEnDisMenuItem (Message, QueryCmd, label, ShortC);
    else
      IMenuItem = new QueryEnDisMenuItem (Message, QueryCmd, label);

    AMenu.add(IMenuItem);
//    IMenuItem.setFont(getFont());
    IMenuItem.setCheckStatusListener(IMenuItem);
    return IMenuItem;
  }

  /* Package access - for ReopenMenuMan*/
  IdeMenuItem AddMItemTo(IdeMenu AMenu, int Message, String label, boolean SetDefEnDis) {
    return AddMItemTo(AMenu, Message, label, SetDefEnDis, null);
  }

  protected QueryEnDisMenuItem AddMItemTo(IdeMenu AMenu, int Message, int QueryCmd, String label) {
    return AddMItemTo(AMenu, Message, QueryCmd, label, null);
  }

  protected IdeMenu AddIMenu(int Message, String label, int Key) {
    IdeMenu IMenu = new IdeMenu(Message);
    IMenu.addMenuListener (IMenu);
    IMenu.setText(label);
//    IMenu.setFont(getFont());
//    IMenu.setShortcut(new MenuShortcut(Key, false));
    add(IMenu);
    IMenu.setPopupMenuVisible(true);
    IMenu.setVisible(true);
    return IMenu;
  }

  protected void Init() {
//    setFont(new Font("Courier", 0, 12));

    mnuFile    = AddIMenu(msgmFile     , "File"     , KeyEvent.VK_F);
    mnuEdit    = AddIMenu(msgmEdit     , "Edit"     , KeyEvent.VK_E);
    mnuSearch  = AddIMenu(msgmSearch   , "Search"   , KeyEvent.VK_S);
    mnuView    = AddIMenu(msgmView     , "View"     , KeyEvent.VK_V);
    mnuProject = AddIMenu(msgmProject  , "Project"  , KeyEvent.VK_P);
    mnuBuild   = AddIMenu(msgmBuild    , "Build"    , KeyEvent.VK_B);
    mnuRun     = AddIMenu(msgmRun      , "Run"      , KeyEvent.VK_R);
    mnuWizards = AddIMenu(msgmWizards  , "Wizards"  , KeyEvent.VK_W);
    mnuTools   = AddIMenu(msgmTools    , "Tools"    , KeyEvent.VK_T);
    mnuHelp    = AddIMenu(msgmHelp     , "Help"     , KeyEvent.VK_H);

    // Begin of Menu File
    // --------------------------------------------------------------------------------------
    AddMItemTo(mnuFile  , msgmiFileNew,                "New",                 true, new MenuShortcut(KeyEvent.VK_N));
    AddMItemTo(mnuFile  , msgmiFileOpen,               "Open",                true);
    AddSubmenuTo (mnuFile, msgmiFileReopen, "Reopen");
    new ReopenMenuMan();

    AddMItemTo(mnuFile  , msgmiFileClose,    SystemEvent.msgMenuQuery_CanClose,    "Close");
    AddMItemTo(mnuFile  , msgmiFileCloseAll, SystemEvent.msgMenuQuery_CanCloseAll, "CloseAll");

    mnuFile.addSeparator();
    AddMItemTo(mnuFile  , msgmiFileSave,        SystemEvent.msgMenuQuery_CanSave,        "Save",    new MenuShortcut(KeyEvent.VK_S));
    AddMItemTo(mnuFile  , msgmiFileSaveAs,      SystemEvent.msgMenuQuery_CanSaveAs,      "SaveAs",  new MenuShortcut(KeyEvent.VK_A));
    AddMItemTo(mnuFile  , msgmiFileSaveAll,     SystemEvent.msgMenuQuery_CanSaveAll,     "SaveAll", new MenuShortcut(KeyEvent.VK_Q, true));

    mnuFile.addSeparator();
//    AddMItemTo(mnuFile  , msgmiFileRemoveFromProject,  "Remove from project", true);
//    AddMItemTo(mnuFile  , msgmiFileRename,             "Rename",              true);

//    AddMItemTo(mnuFile  , msgmiFilePrinterSetup,       "Printer Setup",       true);
//    AddMItemTo(mnuFile  , msgmiFilePrint,              "Print",               true);
    AddMItemTo(mnuFile  , msgmiFileExit,               "Exit",                false);
    // --------------------------------------------------------------------------------------

    // Begin of Menu Edit
    // --------------------------------------------------------------------------------------
    AddMItemTo(mnuEdit  , msgmiEditUndo, SystemEvent.msgMenuQuery_CanUndo, "Undo");
    AddMItemTo(mnuEdit  , msgmiEditRedo, SystemEvent.msgMenuQuery_CanRedo, "Redu");

    AddMItemTo(mnuEdit  , msgmiEditCut,       SystemEvent.msgMenuQuery_CanCut,       "Cut",    new MenuShortcut(KeyEvent.VK_DELETE, true));
    AddMItemTo(mnuEdit  , msgmiEditCopy,      SystemEvent.msgMenuQuery_CanCopy,      "Copy",   new MenuShortcut(KeyEvent.VK_INSERT));
    AddMItemTo(mnuEdit  , msgmiEditPaste,     SystemEvent.msgMenuQuery_CanPaste,     "Paste",  new MenuShortcut(KeyEvent.VK_INSERT, true));
    AddMItemTo(mnuEdit  , msgmiEditDelete,    SystemEvent.msgMenuQuery_CanDelete,    "Delete", new MenuShortcut(KeyEvent.VK_DELETE, true));
    AddMItemTo(mnuEdit  , msgmiEditSelectAll, SystemEvent.msgMenuQuery_CanSelectAll, "SelectAll");
    // --------------------------------------------------------------------------------------

    // Begin of Menu Search
    // --------------------------------------------------------------------------------------
    AddMItemTo(mnuSearch, msgmiSearchFind,     SystemEvent.msgMenuQuery_CanFind,       "Find", new MenuShortcut(KeyEvent.VK_F));
    AddMItemTo(mnuSearch, msgmiSearchReplace,  SystemEvent.msgMenuQuery_CanReplace,    "Replace");
    AddMItemTo(mnuSearch, msgmiSearchFindAgain,SystemEvent.msgMenuQuery_CanSearchAgain,"Find Again", new MenuShortcut(KeyEvent.VK_F3));
    mnuSearch.addSeparator();
    AddMItemTo(mnuSearch, msgmiSearchGoToLineNumber, SystemEvent.msgMenuQuery_CanGoToLineNumber, "Go to line number");
    mnuSearch.addSeparator();
    AddMItemTo(mnuSearch, msgmiSearchBrowse, "Browse", true);
    // --------------------------------------------------------------------------------------

    // Begin of Menu View
    // --------------------------------------------------------------------------------------
    AddMItemTo(mnuView, msgmiViewOutput,   "Output",        true);
    AddMItemTo(mnuView, msgmiViewDebugger, "Project Panel", true);
    // --------------------------------------------------------------------------------------

    // Begin of Menu Project
    // --------------------------------------------------------------------------------------
    AddMItemTo(mnuProject, msgmiProjectNew,            "New",                 true);
    AddMItemTo(mnuProject, msgmiProjectOpenCreate,     "Open / Create",       true);
    AddMItemTo(mnuProject, msgmiProjectRemoveFromProject, "Remove From Project", true);

    IdeMenu OpenMenu = AddSubmenuTo (mnuProject, msgmOpen, "Add");

    AddMItemTo(OpenMenu  , msgmiOpenPackage,     "Package"         ,true);
    AddMItemTo(OpenMenu  , msgmiOpenPackageTree, "Package Tree"    ,true);
    AddMItemTo(OpenMenu  , msgmiOpenDirectory,   "Directory"       ,true);
    AddMItemTo(OpenMenu  , msgmiOpenDirTree,     "Directories Tree",true);

    AddMItemTo(mnuProject, msgmiProjectClose,          "Close",               true);
    AddMItemTo(mnuProject, msgmiProjectSave,           "Save",                true);
    AddMItemTo(mnuProject, msgmiProjectSaveAs,         "Save As",             true);
    AddMItemTo(mnuProject, msgmiProjectRename,         "Rename",              true);
    AddMItemTo(mnuProject, msgmiProjectProperties,     "Properties",          true);
    AddMItemTo(mnuProject, msgmiProjectStore,          "Store in JAR",        true);
    AddMItemTo(mnuProject, msgmiProjectDocumentation,  "Generate Docs",       true);
    // --------------------------------------------------------------------------------------

    // Begin of Menu Build
    // --------------------------------------------------------------------------------------
    AddMItemTo(mnuBuild , msgmiBuildMakeProject,       "Make Project",        true);
    AddMItemTo(mnuBuild , msgmiBuildRebuildProject,    "Rebuild Project",     true);
    mnuBuild.addSeparator();
    AddMItemTo(mnuBuild , msgmiBuildMake,              "Make",                true);
    AddMItemTo(mnuBuild , msgmiBuildRebuild,           "Rebuild",             true);
    // --------------------------------------------------------------------------------------

    // Begin of Menu Run
    // --------------------------------------------------------------------------------------
    AddMItemTo(mnuRun   , msgmiRunRun,                 "Run",                 true);
    AddMItemTo(mnuRun   , msgmiRunDebug,               "Debug",               true);
    // --------------------------------------------------------------------------------------

    // Begin of Menu Wizards
    // --------------------------------------------------------------------------------------
    AddMItemTo(mnuWizards , msgmiWizardsAppletWizard,  "Applet Wizard",       true);
    AddMItemTo(mnuWizards , msgmiWizardsApplicationWizard, "Application Wizard", true);
    // --------------------------------------------------------------------------------------

    // Begin of Menu Tools
    // --------------------------------------------------------------------------------------
//    AddMItemTo(mnuTools , msgmiToolsAddTool,           "Add Tool",            true);
//    AddMItemTo(mnuTools , msgmiToolsEditTool,          "Edit Tool",           true);
//    AddMItemTo(mnuTools , msgmiToolsSaveTool,          "Save Tools",          true);
//    mnuTools.addSeparator();
    AddMItemTo(mnuTools , msgmiToolsEnviromentOptions, "Enviroment Options",  true);
    AddMItemTo(mnuTools , msgmiToolsConfigurePalette,  "Configure Palette",   true);
//    mnuTools.addSeparator();
//    AddMItemTo(mnuTools , msgmiToolsConfigureTool,     "Configure Tool",      true);
    // --------------------------------------------------------------------------------------

    // Begin of Menu Help
    // --------------------------------------------------------------------------------------
    AddMItemTo(mnuHelp  , msgmiHelpAbout,              "About",               true);
    // --------------------------------------------------------------------------------------
  }

}
