/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.ide;

import com.sun.java.swing.tree.*;
import com.sun.java.swing.*;
import org.freebuilder.system.projectman.*;
import org.freebuilder.system.packages.*;
import org.freebuilder.system.ideengine.*;
import java.util.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class ProjectTreeItem implements MutableTreeNode {
  private Vector ProjectFiles = null;
  private ProjectTreeItem TheParent;
  private PacketItemI TheFile;
  private ImageIcon TheIcon;
  private boolean LazyInitOK = false;
  private int NodeKind;
  private String DefaultName;

  public ProjectTreeItem (ProjectTreeItem Parent, PacketItemI File, int NodeKind, String DefName) {
    int i;
    int Count;
    TheParent = Parent;
    TheFile   = File;
    DefaultName = DefName;
    this.NodeKind = NodeKind;

    if (Parent == null) {
      Count = Globals.PItems.getCount();
      ProjectFiles = new Vector ();
      for (i = 0; i < Count; i++)
        ProjectFiles.addElement (new ProjectTreeItem (this, Globals.PItems.getPacketItem(i),
                                                            Globals.PItems.getPacketItemKind(i),
                                                            Globals.PItems.getString(i)));
      TheIcon = ProjectTreeRenderer.ProjectFile;
      LazyInitOK = true;
      return;
    }

    if (TheFile == null) {
      switch (NodeKind) {
        case BrowseCollItem.ikPackage:
          TheIcon = ProjectTreeRenderer.PackageUnr;
        break;
        case BrowseCollItem.ikPackagesRoot:
          TheIcon = ProjectTreeRenderer.PackageRootUnr;
        break;
        default:
          TheIcon = ProjectTreeRenderer.UnknownType;
      }
      LazyInitOK = true;
      return;
    }

    switch (NodeKind) {
      case BrowseCollItem.ikFile:
        switch (TheFile.getPacketItemKind()) {
          case PacketItemI.cpikSource:
          case PacketItemI.cpikClass:
          case PacketItemI.cpikHtml:
            TheIcon = ProjectTreeRenderer.KnownType;
          break;
          case PacketItemI.cpikAny:
            TheIcon = ProjectTreeRenderer.UnknownType;
          break;
        }
      break;
      case BrowseCollItem.ikDirectory:
        TheIcon = ProjectTreeRenderer.Directory;
      break;
      case BrowseCollItem.ikDirectoryRoot:
        TheIcon = ProjectTreeRenderer.DirectoryRoot;
      break;
      case BrowseCollItem.ikPackage:
        TheIcon = ProjectTreeRenderer.Package;
      break;
      case BrowseCollItem.ikPackagesRoot:
        TheIcon = ProjectTreeRenderer.PackageRoot;
      break;
      default:
        TheIcon = ProjectTreeRenderer.UnknownType;
    }
  }

  public int getNodeKind () {
    return NodeKind;
  }

  private void LazyInit () {
    int Count = TheFile.getPacketItemsCount();
    int i;
    ProjectTreeItem NewEntry;

    switch (NodeKind) {
      case BrowseCollItem.ikDirectory:
        if (Count == 0)
          break;
        ProjectFiles = new Vector();
        for (i = 0; i < Count; i++) {
          PacketItemI CurrentItem = TheFile.getPacketItemAt (i);
          if ((CurrentItem.getPacketItemKind() == PacketItemI.cpikPacket) ||
              (CurrentItem.getPacketItemKind() == PacketItemI.cpikDirectory))
             continue;
          NewEntry = new ProjectTreeItem (this, CurrentItem, BrowseCollItem.ikFile, null);
          ProjectFiles.insertElementAt (NewEntry, findEntryPos(NewEntry));
        }
      break;
      case BrowseCollItem.ikDirectoryRoot:
        if (Count == 0)
          break;
        ProjectFiles = new Vector();
        for (i = 0; i < Count; i++) {
          PacketItemI CurrentItem = TheFile.getPacketItemAt (i);
          if ((CurrentItem.getPacketItemKind() == PacketItemI.cpikPacket) ||
              (CurrentItem.getPacketItemKind() == PacketItemI.cpikDirectory))
            NewEntry = new ProjectTreeItem (this, CurrentItem, BrowseCollItem.ikDirectoryRoot, null);
          else
            NewEntry = new ProjectTreeItem (this, CurrentItem, BrowseCollItem.ikFile, null);
          ProjectFiles.insertElementAt (NewEntry, findEntryPos (NewEntry));
        }
      break;
      case BrowseCollItem.ikPackage:
        if (Count == 0)
          break;
        ProjectFiles = new Vector();
        for (i = 0; i < Count; i++) {
          PacketItemI CurrentItem = TheFile.getPacketItemAt (i);
          if ((CurrentItem.getPacketItemKind() == PacketItemI.cpikSource) ||
              (CurrentItem.getPacketItemKind() == PacketItemI.cpikClass)) {
            NewEntry = new ProjectTreeItem (this, CurrentItem, BrowseCollItem.ikFile, null);
            ProjectFiles.insertElementAt (NewEntry, findEntryPos(NewEntry));
          }
        }
      break;
      case BrowseCollItem.ikPackagesRoot:
        if (Count == 0)
          break;
        ProjectFiles = new Vector();
        for (i = 0; i < Count; i++) {
          PacketItemI CurrentItem = TheFile.getPacketItemAt (i);
          if (CurrentItem.getPacketItemKind() == PacketItemI.cpikPacket) {
            NewEntry = new ProjectTreeItem (this, CurrentItem, BrowseCollItem.ikPackagesRoot, null);
            ProjectFiles.insertElementAt (NewEntry, findEntryPos(NewEntry));
          }
          if ((CurrentItem.getPacketItemKind() == PacketItemI.cpikSource) ||
              (CurrentItem.getPacketItemKind() == PacketItemI.cpikClass)) {
            NewEntry = new ProjectTreeItem (this, CurrentItem, BrowseCollItem.ikFile, null);
            ProjectFiles.insertElementAt (NewEntry, findEntryPos(NewEntry));
          }
        }
      break;
    }
    LazyInitOK = true;
  }

  public ImageIcon getIcon () {
    return TheIcon;
  }

  public String toString () {
    if (TheParent == null)
      return Globals.getProjectTitleName();

    if (TheFile == null)
      return DefaultName;

    switch (NodeKind) {
      case BrowseCollItem.ikPackage:
      case BrowseCollItem.ikPackagesRoot:
        return TheFile.getDotName();
      case BrowseCollItem.ikDirectory:
      case BrowseCollItem.ikDirectoryRoot: {
        String Ret = TheFile.getRelativeDosPath();
        if (Ret.length() > 0)
          return Ret;
        return TheFile.getFullDosPath();
      }
    }
    return TheFile.getFileName();
  }

  public Enumeration children() {
    if (!LazyInitOK)
      LazyInit();
    if (ProjectFiles == null)
      return null;
    return ProjectFiles.elements();
  }

  public boolean getAllowsChildren() {
    return true;
  }

  public TreeNode getChildAt (int Index) {
    if (!LazyInitOK)
      LazyInit();
    if (ProjectFiles == null)
       return null;
    return (ProjectTreeItem) ProjectFiles.elementAt(Index);
  }

  public int getChildCount() {
    if (!LazyInitOK)
      LazyInit();
    if (ProjectFiles == null)
      return 0;
    return ProjectFiles.size();
  }

  public int getIndex(TreeNode Child) {
    if (!LazyInitOK)
      LazyInit();
    if (ProjectFiles == null)
      return -1;
    return ProjectFiles.indexOf (Child);
  }

  public TreeNode getParent() {
    return TheParent;
  }

  public boolean isLeaf() {
    if (!LazyInitOK)
      if (NodeKind == BrowseCollItem.ikFile)
        return true;
      else
        return false;
    if ((ProjectFiles == null) || (ProjectFiles.size() == 0))
      return true;
    return false;
  }

  public String getFileName () {
    if (TheFile != null)
      if ((NodeKind == BrowseCollItem.ikPackage) ||
          (NodeKind == BrowseCollItem.ikPackagesRoot))
         return TheFile.getDotName();
      else
         return TheFile.getFullDosPath();
    return DefaultName;
  }

  public PacketItemI getFile () {
    return TheFile;
  }

  public boolean isToBeShown () {
    if (getFile() == null)
      return false;
    return getFile().getPacketItemKind() == PacketItemI.cpikSource;
  }

  public TreePath getPathToNode (String FileToSelect, int Count) {
    if (FileToSelect == null)
      return null;

    if ((getFile() != null) && (getFile().getFullDosPath().equalsIgnoreCase (FileToSelect))) {
      Object [] PathData = new Object [Count];
      int i = Count -1;
      TreeNode CurrentNode = this;
      do {
        PathData[i] = CurrentNode;
        CurrentNode = CurrentNode.getParent();
        i--;
      } while (i >= 0);
      return new TreePath (PathData);
    }

    if ((getNodeKind() > 0) && (getFile() == null))
      return null;

    if (getFile() != null) {
      String ThisNameLow   = getFile().getFullDosPath().toLowerCase();
      String SearchNameLow = FileToSelect.toLowerCase();
      if (!SearchNameLow.startsWith (ThisNameLow))
        return null;
    }

    if (!LazyInitOK)
      LazyInit();
    if (ProjectFiles == null)
      return null;

    int i;
    int ChilderenCount = ProjectFiles.size();
    for (i = 0; i < ChilderenCount; i++) {
      ProjectTreeItem CurrentChild = (ProjectTreeItem) ProjectFiles.elementAt(i);
      TreePath PathToNode = CurrentChild.getPathToNode(FileToSelect, Count + 1);
      if (PathToNode != null) {
        return PathToNode;
      }
    }
    return null;
  }

  public Vector getChildren () {
    return ProjectFiles;
  }

/// --------------- Methods from MutableTreeNode -----------------------
  public void insert (MutableTreeNode NewNode, int AtPosition) {
    ProjectFiles.insertElementAt (NewNode, AtPosition);
  }

  public void remove (int FromPosition) {
    ProjectFiles.removeElementAt (FromPosition);
  }
  public void remove (MutableTreeNode OldNode) {
    ProjectFiles.removeElement (OldNode);
  }

   public void removeFromParent () {
    ((ProjectTreeItem)getParent()).remove (this);
  }
  public void setParent (MutableTreeNode NewParent) {
    TheParent = (ProjectTreeItem)NewParent;
  }
  public void setUserObject(Object NewData) {} // I don't use this.

  private boolean isLess (int Group1, int Group2) {
    int [] Order = new int [] {
      BrowseCollItem.ikPackagesRoot,
      BrowseCollItem.ikPackage,
      BrowseCollItem.ikFile,
      BrowseCollItem.ikDirectory,
      BrowseCollItem.ikDirectoryRoot
    };
    int i,j;
    for (i = 0; i < 5; i++)
      if (Group1 == Order[i])
        break;
    for (j = 0; j < 5; j++)
      if (Group2 == Order[j])
        break;
    return i >= j;
  }

  private int findGroupStartIndex (int GroupKind) {
    int i;
    for (i = 0; i < ProjectFiles.size(); i++) {
      ProjectTreeItem CurrentEntry = (ProjectTreeItem) ProjectFiles.elementAt(i);
      if (isLess (CurrentEntry.getNodeKind(),GroupKind))
        break;
    }
    return i;
  }

  public int findEntryPos (ProjectTreeItem NewEntry) {
    int StartPos = findGroupStartIndex (NewEntry.getNodeKind());
    int LastPos;
    int i;

    for (i = StartPos; i < ProjectFiles.size(); i++) {
      ProjectTreeItem CurrentEntry = (ProjectTreeItem) ProjectFiles.elementAt(i);
      if (CurrentEntry.getNodeKind() != NewEntry.getNodeKind())
        break;
    }
    LastPos = i;

    for (i = StartPos; i < LastPos; i++) {
      ProjectTreeItem CurrentEntry = (ProjectTreeItem) ProjectFiles.elementAt(i);
        if (CurrentEntry.toString().compareTo (NewEntry.toString()) > 0)
          return i;
    }
    return i;
  }
}

