/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.config;

import com.sun.java.swing.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.gui.beans.*;
import java.awt.*;
/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class CompilerOptionsPanel extends BPanel implements Configurator {

  private JCheckBox Deprecation        = new JCheckBox ("Deprecated warnings ON", true);
  private JCheckBox SpeedOptim         = new JCheckBox ("Optimize for Speed");
  private JCheckBox NoWarning          = new JCheckBox ("Warnings OFF");

  private ButtonGroup DebugInfo        = new ButtonGroup ();

  private JRadioButton NoDebugInfo        = new JRadioButton ("Debug Info OFF", false);
  private JRadioButton LineNumberOnly     = new JRadioButton ("Line Number Info Only", false);
  private JRadioButton FullDebugInfo      = new JRadioButton ("Complete Debug Info", true);

  private JCheckBox Verbose            = new JCheckBox ("Detail Compilation Info", true);
  private JCheckBox Depend             = new JCheckBox ("Recompile dependents", true);

  private JTextField OtherOptions     = new JTextField();
  private BPanel PathsPanel           = new BPanel("Paths");


  public CompilerOptionsPanel () {
    super("Java Compiler Options");
    DebugInfo.add (NoDebugInfo);
    DebugInfo.add (LineNumberOnly);
    DebugInfo.add (FullDebugInfo);

    BPanel OtherOptionsPanel              = new BPanel("Other Options:");
    BPanel OptionsPanel                   = new BPanel("Options:");
    BPanel DebugInfoPanel                 = new BPanel("Debug Info:");
    BPanel SouthPanel                     = new BPanel();
    BPanel VerboseDependPanel             = new BPanel();
    BPanel OptionsAndDebugInfoPanel       = new BPanel();
    BPanel VerboseDependAndOtherOptsPanel = new BPanel();
    BPanel NorthOfSouthPanel              = new BPanel();

    setLayout (new BorderLayout ());

    SouthPanel.setLayout (new BorderLayout(5,5));

    NorthOfSouthPanel.setLayout (new BorderLayout());
    NorthOfSouthPanel.setInner  (BPanel.NONE);
    NorthOfSouthPanel.setOuter  (BPanel.NONE);

    OptionsAndDebugInfoPanel.setLayout (new GridLayout (1, 2, 5, 5));
    OptionsAndDebugInfoPanel.setInner (BPanel.NONE);
    OptionsAndDebugInfoPanel.setOuter (BPanel.NONE);
    OptionsPanel.setLayout (new GridLayout(3, 1));

    OptionsPanel.add (Deprecation);
    OptionsPanel.add (SpeedOptim);
    OptionsPanel.add (NoWarning);
    OptionsAndDebugInfoPanel.add (OptionsPanel);
    // OptionsPanel added.

    DebugInfoPanel.setLayout (new GridLayout(3, 1));
    DebugInfoPanel.add (NoDebugInfo);
    DebugInfoPanel.add (LineNumberOnly);
    DebugInfoPanel.add (FullDebugInfo);
    OptionsAndDebugInfoPanel.add (DebugInfoPanel);
    // DebugInfoPanel added.

    NorthOfSouthPanel.add (OptionsAndDebugInfoPanel, BorderLayout.SOUTH);
    // Options and DebugInfo checkboxes added South in NorthOfSouthPanel

    SouthPanel.add (NorthOfSouthPanel, BorderLayout.NORTH);
    // The North part of SouthPannel added.

    VerboseDependAndOtherOptsPanel.setInner (BPanel.NONE);
    VerboseDependAndOtherOptsPanel.setOuter (BPanel.NONE);
    VerboseDependAndOtherOptsPanel.setLayout (new BorderLayout (5 , 5));

    OtherOptionsPanel.setLayout (new BorderLayout ());
    OtherOptionsPanel.add (OtherOptions, BorderLayout.CENTER);
    VerboseDependAndOtherOptsPanel.add
      (OtherOptionsPanel, BorderLayout.NORTH);
    // OtherOptions added North in VerboseDependAndOtherOptsPanel

    VerboseDependPanel.setLayout (new GridLayout(1, 2, 5, 5));
    VerboseDependPanel.add (Verbose);
    VerboseDependPanel.add (Depend);
    VerboseDependAndOtherOptsPanel.add
      (VerboseDependPanel, BorderLayout.SOUTH);
    // Verobose and Depend chackboxes added South in VerboseDependPanel

    SouthPanel.add (VerboseDependAndOtherOptsPanel,
                    BorderLayout.SOUTH);
    // VerboseDependPanel added South in SouthPanel

    add (SouthPanel, BorderLayout.NORTH);
    // SouthPanel added south.
    PathsPanel.setLayout (new GridLayout(1, 2, 3, 3));
    add (PathsPanel, BorderLayout.SOUTH);
    getOptions ();
  }

  public String toString () {
    return "Java Compiler";
  }

  public void setPaths () {
    PathsPanel.removeAll();
    PathsPanel.add (PathsOptionsConfig.getClassPathPanel ());
    PathsPanel.add (PathsOptionsConfig.getClassOutPathPanel ());
  }

  public void initGUI () {
    setPaths();
  }

  public Component getGUI () {
    return this;
  }

  public void getOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    CompilerOptions  NewOptions = (CompilerOptions)(AOptions.getOptions(CompilerOptions.CompilerManOptionsName));

    Verbose.setSelected    (NewOptions.isVerbose());
    Depend.setSelected     (NewOptions.isDepend());
    Deprecation.setSelected(NewOptions.isDeprecation());
    SpeedOptim.setSelected (NewOptions.isSpeedOptim());
    NoWarning.setSelected  (NewOptions.isNoWarning());
    OtherOptions.setText(NewOptions.getOtherOptions ());

    switch (NewOptions.getDebugInfoFlags ()) {
    case CompilerOptions.NO_DEBUG_INFO:
      NoDebugInfo.setSelected(true);
      break;
    case CompilerOptions.FULL_DEBUG_INFO:
      FullDebugInfo.setSelected(true);
      break;
    case CompilerOptions.LINE_NUMBERS_INFO_ONLY:
      LineNumberOnly.setSelected(true);
      break;
    }
  }

  public void setOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    CompilerOptions  NewOptions = (CompilerOptions)(AOptions.getOptions(CompilerOptions.CompilerManOptionsName));

    NewOptions.setVerbose      (Verbose.isSelected());
    NewOptions.setDepend       (Depend.isSelected());
    NewOptions.setDeprecation  (Deprecation.isSelected());
    NewOptions.setSpeedOptim   (SpeedOptim.isSelected());
    NewOptions.setNoWarning    (NoWarning.isSelected());
    NewOptions.setOtherOptions (OtherOptions.getText());

    if (NoDebugInfo.isSelected())
      NewOptions.setDebugInfoFlags (CompilerOptions.NO_DEBUG_INFO);
    if (FullDebugInfo.isSelected())
      NewOptions.setDebugInfoFlags (CompilerOptions.FULL_DEBUG_INFO);
    if (LineNumberOnly.isSelected())
      NewOptions.setDebugInfoFlags (CompilerOptions.LINE_NUMBERS_INFO_ONLY);
    AOptions.setOptions (NewOptions);
  }
}


