/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.beans;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class ReplaceDialog extends FindDialog implements ActionListener {
  private String REPLACE_ALL_CMD    = "ReplaceAll";
  private Button ReplaceAllButton   = new Button ("Replace All");
  private JTextField ReplaceWith    = new JTextField ();
  private JCheckBox PromptOnReplace = new JCheckBox ("Prompt on replace");
  private BPanel ReplaceWithPanel   = new BPanel ("Replace with");
  private boolean isToReplaceAll    = false;

  public ReplaceDialog () {
    ButtonsPanel.setLayout (new GridLayout(1, 3, 5, 5));
    ButtonsPanel.add (ReplaceAllButton);

    ReplaceWithPanel .setLayout (new BorderLayout());
    ReplaceWithPanel .add (ReplaceWith);

    TextsPanel  .setLayout (new GridLayout (2, 1, 1, 1));
    TextsPanel  .add (ReplaceWithPanel);

    OptionsPanel.setLayout (new GridLayout(3, 1, 1, 1));
    OptionsPanel.add       (PromptOnReplace);

    ReplaceAllButton.addActionListener (this);
    pack();
    Misc.hardCenter (this);
  }

  public void actionPerformed (ActionEvent e) {
    if (e.getSource().equals(ReplaceAllButton)) {
      Confirmed = true;
      isToReplaceAll = true;
    }

    setVisible (false);
  }

  public boolean isPromptOnReplace() {
    return PromptOnReplace.isSelected();
  }

  public boolean isToReplaceAll() {
    return isToReplaceAll;
  }

  public String getReplaceWith() {
    return ReplaceWith.getText();
  }
}
