/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */


package org.freebuilder.tools.editor;

import org.freebuilder.gui.editors.*;
import org.freebuilder.gui.beans.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
/** This class implements the edited file read and write functionality. */
public class EditFile implements TextEditorI {

  private Reader           TheFile       = null;
  private String           TheFileName   = null;
  private int              CaretPosition = 0;
  private SourceTextArea TheSourceArea = new SourceTextArea();
  private boolean ReadOnly;
  private long FileSize;

	public EditFile (Reader TheFile, String TheFileName, boolean ReadOnly, long Size) {
		super();
    this.TheFile = TheFile;
    this.ReadOnly = ReadOnly;
    FileSize = Size;
		setFullDosPath (TheFileName);
    CaretPosition = 0;
    readBuffer();
    if (ReadOnly)
      TheSourceArea.setEditable (false);
    else
      TheSourceArea.setEditable (true);
	}

	protected void readBuffer() {
    if (TheFile != null) {
      try {
        char charbuf[]        = new char [(int)FileSize];
        TheFile.read  (charbuf,0,(int)FileSize);
        TheFile.close ();
        TheSourceArea.setText (new String(charbuf));
      } catch (Exception x) {
        System.out.println(x);
        TheSourceArea.setText("");
      };
    } else
      TheSourceArea.setText("");
  }

  public void save() throws IOException {
    if (ReadOnly)
      return;
    if (TheSourceArea.getText() != null) {
      File TheFile = new File ((new File (TheFileName)).getParent());
      TheFile.mkdirs();
      FileWriter fw     = new FileWriter(TheFileName);
      BufferedWriter bw = new BufferedWriter(fw);
      bw.write(TheSourceArea.getText(),0,TheSourceArea.getText().length());
      bw.flush();
      fw.close();
      TheSourceArea.setModified (false);
    }
  }

//======================== TextEditorI implementation =====================

  public boolean isReadOnly() {
    return ReadOnly;
  }

  public SourceTextArea getSourceArea() {
    return TheSourceArea;
  }

	public void setModified (boolean b) {
    TheSourceArea.setModified (b);
  }
	public boolean isModified() {
    return TheSourceArea.isModified ();
	}

  public boolean exists () {
    return (new File (TheFileName)).exists();
  }

  public boolean saveIt()   {
    if (TheSourceArea.isModified())
      return saveFile();
    return true;
  }

  public boolean saveFile() {
    try {save();}
    catch (IOException e) {
      Misc.messageBox (new String [] {"OK"}, new String [] {"Unable to save file", TheFileName}, 0);
      return false;
    }
    return true;
  }

  public  String getFullDosPath() {
    return TheFileName;
  }

  public  void setFullDosPath(String FName) {
    TheFileName = FName;
  }

  public  String getDotName()     { return null; }
  public  String getFileName()    { return TheFileName; }
  public  boolean isStable()     { return ReadOnly; }
  public int     getCursorPos()      { return CaretPosition; }
  public void    setCursorPos(int NewPosition) { CaretPosition = NewPosition; }
  public String  getStringAtCursor() { return null; }
  public String  getText()           { return TheSourceArea.getText(); }

  public boolean canGoToLineNumber() { return false; }
  public boolean doGoToLineNumber (int ALineNumber) { return false; }
}
