/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.projectman;

import java.util.EventObject;
import java.io.*;

import org.freebuilder.system.classes.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.system.classes.options.opened.*;


/** This class is some super class for ProjectManager, or for some Collection of Items we
  * want to Browse.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
*/

public class BrowseManager {
  boolean IsSendEventsEnabled = false;

  public BrowseManager() {
    AddListeners();
  }

  protected String getBrowseCollOptionsName() {
    String OptionsName = "";
    BrowseCollection BrColl = getBrowseCollOptions();
    if (BrColl != null) {
      OptionsName = BrColl.getName();
      if (OptionsName != null) return OptionsName;
    }
    Debug.Assert(this, "Can not find Options Name "); 
    return "";
  }

  public void AddListeners() {
    String OptionsName = getBrowseCollOptionsName();
    if (OptionsName.length() == 0) return;

    Globals.AddDoBrowseCollAdapter(OptionsName, BrowseCollItemEvent.msgAddItem   , this,"DoAddBrowseItem");
    Globals.AddDoBrowseCollAdapter(OptionsName, BrowseCollItemEvent.msgRemoveItem, this,"DoRemoveBrowseItem");
  }

  public void EnableSendEvents(boolean AEnable) {
    if (IsSendEventsEnabled == AEnable) return;
    IsSendEventsEnabled = AEnable;
  }

  public boolean IsSendEventsEnabled() { return IsSendEventsEnabled; }

   /** return Project Options nomater if they are default options */
  public BrowseCollection getBrowseCollOptions() {
    BrowseCollection BrOpts = null; if (Globals.Options == null) return null;
    BrOpts = (BrowseCollection)(Globals.Options.getOptions(BrowseCollection.cDefaultName));
    return BrOpts;
  }

  /** retrun false, if somebody which is received the message Does not want to continue operation */
  BrowseCollItemEvent SendEvent(int EventID, BrowseCollection BrColl, BrowseCollItem ABrItem) {
    if (! IsSendEventsEnabled) return null;
    BrowseCollItemEvent BEvent = new BrowseCollItemEvent(EventID, new EventObject(this), BrColl, ABrItem);
    Globals.EventsEngine.SendEvent(BEvent);
    return BEvent;
  }

  //------------------------------------------------------------------------------------

  BrowseCollItemEvent CheckEvent(IdeSuperEvent AEvent) {
    BrowseCollItemEvent BEvent = (BrowseCollItemEvent)AEvent; if (BEvent == null) return null;
    if (BEvent.BColl == null) {
      Debug.Assert(this, "CheckEvent : BEvent.BColl == null"); return null;
    }
    return BEvent;
  }

  BrowseCollItemEvent CheckWholeEvent(IdeSuperEvent AEvent) {
    BrowseCollItemEvent BEvent = CheckEvent(AEvent); if (BEvent == null) return null;
    if (BEvent.BCItem == null) {
      Debug.Assert(this, "CheckWholeEvent : BEvent.BCItem == null"); return null;
    }
    return BEvent;
  }

  public void DoAddBrowseItem(IdeSuperEvent AEvent) {
    BrowseCollItemEvent BEvent = CheckWholeEvent(AEvent); if (BEvent == null) return;
    BrowseCollItem      BCItem = BEvent.BCItem;
    BrowseCollection    BrOpts = BEvent.BColl;

    if (!BEvent.CanDoThat) return;
    BEvent.Index = BrOpts.addBrowseItem(BCItem);
    if (BEvent.Index < 0) return;

    BEvent.Done = true;
    if (BCItem.getItemKind() == BrowseCollItem.ikFile)
      Globals.Options.OpenFile(BCItem.getItemName());  // Add this file to last opened files
    Globals.Options.setOptions(BrOpts);                // Set new options
  }

  public void DoRemoveBrowseItem(IdeSuperEvent AEvent) {
    BrowseCollItemEvent BEvent = CheckWholeEvent(AEvent); if (BEvent == null) return;
    BrowseCollItem      BCItem = BEvent.BCItem;
    BrowseCollection    BrOpts = BEvent.BColl;

    if (!BEvent.CanDoThat) return;
    BrOpts.Delete(BCItem);
    BEvent.Done = true;
    Globals.Options.setOptions(BrOpts);
  }
  //------------------------------------------------------------------------------------

  int addBrowseItem(BrowseCollItem BCItem) {
    BrowseCollItemEvent Result = null;
    BrowseCollection    BrOpts = getBrowseCollOptions(); if (BrOpts == null) return -1;

    if (BrOpts.isItem(BCItem) >= 0) return -1;
    Result = SendEvent(BrowseCollItemEvent.msgAddItem, BrOpts, BCItem);
    if (Result == null) return -1;
    return Result.Index;
  }

  public boolean removeAllItems() {
    boolean Ret = true;
    while (getCount() > 0) {
      BrowseCollItem CurrentItem = getBrowseCollItem(0);
      Ret &= RemoveBrowseItem (CurrentItem.getItemName(), CurrentItem.getItemKind());
    }
    return Ret;
  }

  public boolean RemoveBrowseItem(String AItemName, int ItemKind) {
    BrowseCollItemEvent Result = null;
    BrowseCollItem      BCItem = null;
    BrowseCollection    BrOpts = getBrowseCollOptions(); if (BrOpts == null) return false;


    int Index;
    int ElemCount = BrOpts.getCount();
    for (Index = 0; Index < ElemCount;Index ++) {
      BCItem = BrOpts.getBrowseCollItem (Index);
      if  ((BCItem.getItemName().equalsIgnoreCase (AItemName)) &&
           (BCItem.getItemKind() == ItemKind))
         break;
    }
    if (Index == ElemCount) return false;
    Result = SendEvent(BrowseCollItemEvent.msgRemoveItem, BrOpts, BCItem);
    if (Result == null) return false;
    return Result.Done;
  }

  public int addBrowseItem(int AKind, String AName) {
    if (Debug.isDebug) Debug.Assert((AKind >= BrowseCollItem.ikFile) && (AKind <= BrowseCollItem.ikDirectoryRoot), this, "Invalid Kind");
    return addBrowseItem(new BrowseCollItem(AKind, AName));
  }

  public int addFile(String AFileName) {
    return addBrowseItem(BrowseCollItem.ikFile , AFileName);
  }

  public int addPackage(String APackageName) {
    return addBrowseItem(BrowseCollItem.ikPackage, APackageName);
  }

  public int addPackageRoot(String APackageName) {
    return addBrowseItem(BrowseCollItem.ikPackagesRoot, APackageName);
  }

  public int addDirectory(String ADirectoryName) {
    return addBrowseItem(BrowseCollItem.ikDirectory, ADirectoryName);
  }

  public int addDirectoryRoot(String ADirectoryName) {
    return addBrowseItem(BrowseCollItem.ikDirectoryRoot, ADirectoryName);
  }

  public BrowseCollItem getBrowseCollItem (String Name) {
    BrowseCollection BrOpts = getBrowseCollOptions(); if (BrOpts == null) return null;
    return BrOpts.getBrowseCollItem(Name);
  }

  public BrowseCollItem getBrowseCollItem (int Index) {
    BrowseCollection BrOpts = getBrowseCollOptions(); if (BrOpts == null) return null;
    return BrOpts.getBrowseCollItem(Index);
  }

  public int getCount() {
    BrowseCollection BrOpts = getBrowseCollOptions(); if (BrOpts == null) return 0;
    return BrOpts.getCount();
  }
}


