/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.packages;

import java.util.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.ideengine.Globals;
import java.io.*;
import java.util.zip.*;

/** <code>PDirectoryEntry</code> is for organizing hirerachically packets and projects
  * every element in this hierarchy (item) have to implement this interface
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12-12-97
*/

public class PZipDirectoryEntry extends PacketsContainer  {
  private boolean LazyInitOK = false;
  public PZipDirectoryEntry(String AFileName, PacketItemI AParentItem, PacketItemI ARootItem) {
    super(AParentItem, ARootItem, AFileName);
    if (AParentItem != null)
      LazyInitOK = true;
  }

  public boolean isChanged () {
    return false;
    // return LastFileModification != TheFile.lastModified();
  }

  public boolean isStable () {
    return true;
  }

  private void lazyInit () {
    Thread.currentThread().setPriority (Thread.MAX_PRIORITY);
    ZipFile FFile = null;
    try {
      FFile = new ZipFile (getFullDosPath());
    } catch (IOException e) {
      System.out.println (e);
      return;
    }
    Enumeration Entries = FFile.entries();
    ZipParser ZipRoot = new ZipParser (null, null, -1);
    ZipEntry CrntZipEntry;
    while (Entries.hasMoreElements()) {
      CrntZipEntry = (ZipEntry)Entries.nextElement();
      ZipRoot.addNode (CrntZipEntry.getName());
    }

    ZipRoot.Root       = this;
    ZipRoot.TheZipFile = FFile;
    ZipRoot.fillItems (this);
    LazyInitOK = true;
  }

  public int getPacketItemsCount() {
    if (!LazyInitOK)
      lazyInit ();
    return super.getPacketItemsCount();
  }
}
