/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events.engine;

/** The class <code>IdeEventListenerI</code> Every listener which wants to handle events have to
  * implement this interface. Every event is dispatched to all listeners which :
  * 1 getEventsClass(); = Event.getClass(), or isChildEventsListener() == true and Event's class is
  *   subclass of getEventsClass()
  * 2 isIdeEventLEnabled() = true.
  * 3 one of ShallCallBefore(), ShallCall(), or ShallCallAfter() functions return true.
  * Events are dispatched in 3 passes to all the listeners for which 1. and 2. are true,
  * First,  to all of them which method ShallCallBefore() returns true. if so their BeforeAction method is called
  * Second  to all of them which method ShallCall()       returns true. if so their OnAction method is called
  * Third   to all of them which method ShallCallAfter () returns true. if so their AfterAction method is called
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public interface IdeEventListenerI { // every listener have to implement this interface
  final public static int BEFORE_CALL_MASK = 1;
  final public static int CALL_MASK        = 2;
  final public static int AFTER_CALL_MASK  = 4;

  /** @return true if shall call BeforeAction function for this listener. */
  public boolean ShallCallBefore();

  /** @return true if shall call OnAction function for this listener. */
  public boolean ShallCall();

  /** @return true if shall call AfterAction function for this listener. */
  public boolean ShallCallAfter();

  /** */
  public void BeforeAction(IdeSuperEvent AEvent);
  public void OnAction    (IdeSuperEvent AEvent);
  public void AfterAction (IdeSuperEvent AEvent);

  public Class getEventsClass();                    /** @return what kind of events will be handled by this listener */
  public boolean isChildEventsListener();           /** @return ture if handle all events derived from this */
  public boolean AcceptEvent(IdeSuperEvent AEvent); /** true - if handle this event */
  void   setIdeEventLEnable(boolean AEnable);       /** Enable or disable dispatching the events to this listener */
  public boolean isIdeEventLEnabled();              /** true, if want to handle the events */
}


