/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.events.*;

import java.util.EventObject;
/**
  This class implements the options of the panel, which contains
  the editor, debugger and output.
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class MainPanelOptions implements OptionsSuperI, Cloneable {
  public static final String MainPanelOptionsName = "Main Panel Options";
  private int VSplitLoc;
  private int HSplitLoc;
  private int ProjSplitLoc;
  private boolean OutputVisible;
  private boolean DebuggerVisible;


  /** Retuns the location of the vertical spliter. */
  public int getVSpliterLoc () {
    return VSplitLoc;
  }
  /** Retuns the location of the horizontal spliter. */
  public int getHSpliterLoc () {
    return HSplitLoc;
  }

  /** Retuns the location of the horizontal project panel spliter. */
  public int getProjSpliterLoc () {
    return ProjSplitLoc;
  }

  /** Stores the location of the vertical spliter. */
  public void setVSpliterLoc (int NewLoc) {
    VSplitLoc = NewLoc;
  }
  /** Stores the location of the horizontal spliter. */
  public void setHSpliterLoc (int NewLoc) {
    HSplitLoc = NewLoc;
  }

  /** Retuns the location of the horizontal project panel spliter. */
  public void setProjSpliterLoc (int NewLoc) {
    ProjSplitLoc = NewLoc;
  }

  /** Retuns true if the debugger panel is visible. */
  public boolean isDebuggerVisible () {
    return DebuggerVisible;
  }
  /** Stores the debugger panel visibility. */
  public void setDebuggerVisible (boolean Vis) {
    DebuggerVisible = Vis;
  }

  /** Returns true if the output panel is visible. */
  public boolean isOutputVisible () {
    return OutputVisible;
  }
  /** Stores the output panel visibility. */
  public void setOutputVisible (boolean Vis) {
    OutputVisible = Vis;
  }

//============= OptionsSuperI implementation ==================
  /** Retuns a clone of this object. */
  public OptionsSuperI Clone() throws CloneNotSupportedException {
    return (MainPanelOptions) clone();
  }

  /** Compares this object with the passed parameter. */
  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    MainPanelOptions Other = (MainPanelOptions) TheOtherOne;
    return (Other.getHSpliterLoc()    != getHSpliterLoc())    ||
           (Other.getVSpliterLoc()    != getVSpliterLoc())    ||
           (Other.getProjSpliterLoc() != getProjSpliterLoc()) ||
           (Other.isDebuggerVisible() != isDebuggerVisible()) ||
           (Other.isOutputVisible()   != isOutputVisible());
  }

  /**
    This function is a part of OptionsSuperI.
    @see OptionsSuperI
  */
  public OptionsEvent PrepareEvent(int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }

  /** Retuns the name of the options. */
  public String getName() {
    return MainPanelOptionsName;
  }

  /** Sets the default options. */
  public void setDefaults() {
    setHSpliterLoc    (400);
    setVSpliterLoc    (200);
    setProjSpliterLoc (200);
    setOutputVisible   (true);
    setDebuggerVisible (true);
  }
}
