/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ide;

import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.*;
import org.freebuilder.system.ideengine.*;
import java.awt.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class ProjectTreeRenderer extends BasicTreeCellRenderer {
  public static ImageIcon UnknownType    = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "UnknownFile.gif"));
  public static ImageIcon KnownType      = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "KnownFile.gif"));
  public static ImageIcon Package        = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Package.gif"));
  public static ImageIcon PackageRoot    = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "PackageRoot.gif"));
  public static ImageIcon PackageUnr     = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "PackageUnreachable.gif"));
  public static ImageIcon PackageRootUnr = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "PackageRootUnreachable.gif"));
  public static ImageIcon Directory      = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Directory.gif"));
  public static ImageIcon DirectoryRoot  = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "DirectoryRoot.gif"));
  public static ImageIcon ProjectFile    = new ImageIcon (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "ProjectFile.gif"));
  public static Font      DisplayFont    = new Font ("Dialog", Font.PLAIN, 12);

  public Component getTreeCellRendererComponent (JTree TheTree,
                                                 Object Value,
                                                 boolean selected,
                                                 boolean expanded,
                                                 boolean leaf,
                                                 int row,
                                                 boolean hasFocus) {
    ProjectTreeItem TheItem = (ProjectTreeItem) Value;
    super.getTreeCellRendererComponent (TheTree, Value, selected, expanded, leaf, row, hasFocus);
    setIcon (TheItem.getIcon());
    setFont(DisplayFont);
    if (TheItem.getFile() == null) {
      setForeground(Color.black);
      return this;
    }

    if (TheItem.getFile().isStable())
      setForeground(Color.gray);
    else
      setForeground(Color.blue);
    return this;
  }
}

