/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.ide;

import com.sun.java.swing.*;
/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class MySplitPane extends JSplitPane {
  private OptionsSetable Boss = null;
  private boolean isSet       = false;
  private boolean LocInvalid  = false;
  private int DiLoc           = 0;

  public MySplitPane (int Ori, OptionsSetable Boss) {
    super (Ori);
    this.Boss = Boss;
  }

  public void setDividerLocation (int DiLoc) {
    this.DiLoc = DiLoc;
    LocInvalid = true;
    super.setDividerLocation (DiLoc);
  }

  public int getDividerLocation () {
    if (LocInvalid)
      return DiLoc;
    else
      return super.getDividerLocation();
  }

  public void doLayout () {
    if (!isShowing())
      return;
    if (!isSet) {
      isSet = true;
      if (Boss != null)
        Boss.getCurrentOptions(null);
        super.doLayout();
    } else
      super.doLayout();

    if (LocInvalid) {
      LocInvalid = false;
      super.setDividerLocation (DiLoc);
    }
  }
}

