/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.beans;

import java.awt.*;
import java.util.*;
import java.awt.event.*;
import org.freebuilder.system.ideengine.*;

//------------------------------------------------------------------------------
// Begin of Misc
//------------------------------------------------------------------------------

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 07-01-98
*/

class SmallListener implements ActionListener, WindowListener {
  String[] Ret;
  Dialog Boss;
  public SmallListener (String[] Ret, Dialog Boss) {
    this.Ret = Ret;
    this.Boss = Boss;
  }
  public void actionPerformed (ActionEvent e) {
    Ret[0] = e.getActionCommand();
    Boss.setVisible(false);
    Boss.dispose();
  }
  public void windowClosed (WindowEvent e) {};
  public void windowIconified (WindowEvent e) {};
  public void windowDeiconified (WindowEvent e) {};
  public void windowActivated (WindowEvent e) {};
  public void windowDeactivated (WindowEvent e) {};
  public void windowOpened (WindowEvent e) {};
  public void windowClosing (WindowEvent e) {
    Ret[0] = "-1";
    Boss.setVisible(false);
    Boss.dispose();
  };
}

/**
   Miscelanious class, implementing a metod for positioning
   components in the center of the screen, exc....
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/
public class Misc {
  private static Window W = null;

  public static String [] cloneStrArray (String [] Source) {
    if (Source == null)
     return null;

    String [] Dest = new String [Source.length];
    int i;
    for (i = 0; i < Source.length; i++)
      Dest [i] = new String (Source[i]);
    return Dest;
  }

  public static boolean isValidID (String VarName) {
    int i;
    char c;
    if (VarName == null)
      return false;

    if (VarName.length() == 0)
      return false;

    c = VarName.charAt(0);
    if (((c < 'a') || (c > 'z')) && ((c < 'A') || (c > 'Z')))
      return false;

    for (i = 1; i < VarName.length(); i++) {
      c = VarName.charAt(i);
      if (((c < '0') || (c > '9')) && ((c < 'a') || (c > 'z')) && ((c < 'A') || (c > 'Z')))
        return false;
    }
    return true;
  }

  public static int messageBox (String[] Buttons, String[] Message, int DefaultButton) {
    Dialog TheDialog = new Dialog (Globals.IdeMainFrame, "Message", true);
    BPanel ButtonsPanel = new BPanel();
    BPanel MessagePanel = new BPanel();
    BPanel MainPanel    = new BPanel();

    ButtonsPanel.setLayout (new GridLayout (1, Buttons.length, 5, 5));
    String [] Ret = new String [1];
    SmallListener Listener = new SmallListener (Ret, TheDialog);

    MessagePanel.setLayout (new GridLayout(Message.length, 1));
    for (int i = 0; i < Message.length; i++)
      MessagePanel.add (new Label (Message[i], Label.CENTER));

    MainPanel.setLayout (new BorderLayout());
    MainPanel.setInner (BPanel.NONE);
    MainPanel.setOuter (BPanel.NONE);
    MainPanel.setBorderWidth (2);

    for (int i = 0; i < Buttons.length; i++) {
      Button CurrentButton = new Button (Buttons[i]);
      CurrentButton.setActionCommand  (new String(String.valueOf(i)));
      CurrentButton.addActionListener (Listener);
      ButtonsPanel.add(CurrentButton);
    }

    MainPanel.add (ButtonsPanel, BorderLayout.SOUTH);
    MainPanel.add (MessagePanel, BorderLayout.NORTH);

    TheDialog.setLayout (new BorderLayout());
    TheDialog.add (MainPanel, BorderLayout.CENTER);
    TheDialog.pack();
    hardCenter (TheDialog);
    TheDialog.setResizable (false);
    TheDialog.addWindowListener (Listener);
    TheDialog.setVisible (true);

    int ret = 0;
    try {
      ret = Integer.parseInt (Ret[0]);
    } catch (Exception e) {}
    if (ret == -1)
      ret = DefaultButton;
    return ret;
  }

  public static boolean compareStrArray (String [] A1, String [] A2) {
    int Count, i;
    if (A1.length != A2.length)
      return true;
    Count = A1.length;
    for (i = 0; i < Count; i++)
      if (A1[i].compareTo(A2[i]) != 0)
        return true;
    return false;
  }

  /** Centers the passed component. */
  public static void hardCenter (Component C) {
    Dimension SS = C.getToolkit().getScreenSize();
    Dimension CS = C.getSize();
    C.setLocation ((SS.width - CS.width) / 2, (SS.height - CS.height) / 2);
  }

  public static int calcStringHeight () {
    int Ret;
    Graphics G;
    if (W == null)
      W = new Window(Globals.IdeMainFrame);
    W.setSize (1,1);
    W.setVisible (true);
    G = W.getGraphics();
    Ret = G.getFontMetrics().getHeight();
    W.setVisible (false);
    return Ret;
  }

  public static int calcStringWidth (String S, Font F) {
    int Ret;
    Graphics G;
    if (W == null)
      W = new Window(Globals.IdeMainFrame);
    W.setSize (1,1);
    W.setVisible (true);
    G = W.getGraphics();
    if (F != null)
      G.setFont (F);
    Ret = G.getFontMetrics().stringWidth (S);
    W.setVisible (false);
    return Ret;
  }

  public static String[] parsePath (String PPath, char Separator) {
    String Path = new String (PPath);
    Vector Paths = new Vector();
    int SemiColomnIndex;
    do {
      SemiColomnIndex = Path.indexOf (Separator);
      if (SemiColomnIndex == 0) {
        Path = Path.substring (1, Path.length());
        continue;
      }

      if (SemiColomnIndex > 0) {
        Paths.addElement (Path.substring(0, SemiColomnIndex));
        Path = Path.substring (SemiColomnIndex + 1, Path.length());
        continue;
      }
      if (Path.length() > 0)
        Paths.addElement (Path);
      break;
    } while (true);

    String [] Ret = new String[Paths.size()];
    Paths.copyInto (Ret);
    return Ret;
  }
  public static String[] getParamsArray (String StrParams) {
//    String StrParams = getParams();
    Vector Params = new Vector();
    int Start = 0;
    int End = 0;
    int Count = StrParams.length();
    while (Start < Count) {
      while ((Start < Count) &&
              ((StrParams.charAt (Start) == ' ') ||
              (StrParams.charAt (Start) == '\t')))
        Start++;
      if (Start == Count)
        break;
      End = Start + 1;
      while ((End < Count) &&
              ((StrParams.charAt (End) != ' ') &&
              (StrParams.charAt (End) != '\t')))
        End++;
//      System.out.println ("["+StrParams.substring(Start,End)+"]");
      Params.addElement(StrParams.substring(Start,End));
      StrParams.substring(End, StrParams.length());
      Start = End + 1;
    }
    String [] Ret = new String [Params.size()];
    Params.copyInto(Ret);
    return Ret;
  }
  
}

//------------------------------------------------------------------------------
// End of Misc
//------------------------------------------------------------------------------

