package org.freebuilder.tools.output;

import org.freebuilder.system.ideengine.*;
import org.freebuilder.gui.beans.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

import com.sun.java.swing.*;

/**
 *  A class implementing the integrated output & error messages handler functions.
 *
 *  @author Ivelin Atanasoff <ivo@mail.techno-link.com>, <ivelin@hotmail.com>
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
 *  @version 0.4.97, 1 April 1997
 */
 /** This class represents the panel, where the output is sent. */
public class Output extends BPanel {
	private JTextArea outputArea              = null;
	private JScrollPane TextAreaScroll        = new JScrollPane();
	private transient PipedInputStream pin    = null;
	private transient PipedOutputStream pout  = null;
	private transient PrintStream stdout      = null;
  private transient PrintStream stderr      = null;
	private transient Thread messageThread    = null;

	public Output() {
		init();
	}

	public void init() {
	  outputArea = new JTextArea ();
	  TextAreaScroll.getViewport().setView (outputArea);
	  setLayout(new BorderLayout());
	  add (TextAreaScroll, BorderLayout.CENTER);
	  setTitle ("Output");
	}

  public void addMessage(String newmsg) {
    int len = outputArea.getText().length();
    outputArea.append(newmsg+"\n");
    if (len+1+newmsg.length() > outputArea.getText().length()) {
      clear();
      outputArea.append(newmsg+"\n");
    }
  }

  public void run() {
    try {
      stdout = System.out;
      stderr = System.err;
      pin  = new PipedInputStream();
      pout = new PipedOutputStream(pin);
      PrintStream prs = new PrintStream (pout);
      System.setOut(prs);
      System.setErr(prs);
			messageThread = new Thread() {
				public synchronized void run() {
          Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
					BufferedReader br =
            new BufferedReader(new InputStreamReader(pin));
          String nextline = null;

					while (true)
						try {
              try {
                wait (200);
              } catch (InterruptedException e) {}
              while (br.ready()) {
                nextline = br.readLine();
                addMessage (nextline);
              }
            } catch (IOException x) {
                getToolkit().beep();
                System.err.println(x);
            }
       }
     };
     messageThread.start();
     } catch (IOException x) {
       System.out.println(x);
     }
  }

	public void clear() {
		outputArea.setText("");
	}

	protected void close() {
		messageThread.stop();
		clear();
    System.setOut(stdout);
    System.setErr(stderr);
    try {
      pout.close();
    } catch (IOException x) {
      System.out.println(x);
    }
	}

  public Dimension getMinimumSize () {
    return new Dimension (1, 1);
  }
}
