/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.projectman;
import java.io.*;
import org.freebuilder.system.packages.*;
import org.freebuilder.system.ideengine.*;
/**  Every Browse Collection (including Project Manager) will work with Items of class
  *  <code>BrowseCollItem</code>. Every Item will have a Kind :
  *  ikFile          - Some file (not neccessarily .java)
  *  ikPackage       - Package. This means that all the files in this package will be compiled.
  *  ikPackagesRoot  - This package and all the packages recursivelly from that path.
  *  ikDirectory     - This is directory and all files in it can be added to a .jar or .zip file.
  *                    So, if you have some resources for the project (immages, sound files .. )
  *                    they will be included in .jar or zip file.
  *  ikDirectoryRoot - The same as ikDirectory, but with it's subdirectories.
  *
  *  When creating an object of kind ipPackage, or ikPackageRoot in the constructor's
  *  parameter AName must be passed relative 'dot' name for that package.
  *    for example : 'org.freebuilder.system.classes'
  *
  *  When creating object of other kind for this parameter must be passed the
  *  full path to the file or directory in Dos format.
  *    for example : 'c:\\FBProject\FreeBuilder\images\someimage.gif
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
*/

public class BrowseCollItem implements Cloneable, Serializable {
  public final static int ikFile          = 0;                  // Some kind of a file (not neccessarily .java)
  public final static int ikPackage       = ikFile         + 1; // package
  public final static int ikPackagesRoot  = ikPackage      + 1; // This package and all the packages recursivelly from that path.
  public final static int ikDirectory     = ikPackagesRoot + 1; // This is directory, and all files in it can be added to a .jar or .zip file.
  public final static int ikDirectoryRoot = ikDirectory    + 1; // The same as ikDirectory, but with it's subdirectories.

  int    ItemKind;
  String ItemDosPath;

  public BrowseCollItem(int AItemKind, String AItemDosPath) {
    ItemKind    = AItemKind;
    ItemDosPath = AItemDosPath;
  }

  public Object clone () {
    Object Cloned = null;
    try { Cloned = super.clone();
    } catch (Exception e) {}
    return Cloned;
  }

  public boolean IsDifferent(BrowseCollItem TheOtherOne) {
    if (TheOtherOne == null) return true;
    return (ItemKind != TheOtherOne.ItemKind) || (ItemDosPath.compareTo(TheOtherOne.ItemDosPath) != 0);
  }

  public int getItemKind () {
    return ItemKind;
  }

  public String getItemName () {
    return ItemDosPath;
  }

  public void PrintContent() {
    switch(ItemKind) {
      case ikFile          : System.out.println("File          : " + getItemName()); break;
      case ikPackage       : System.out.println("Package       : " + getItemName()); break;
      case ikPackagesRoot  : System.out.println("PackagesRoot  : " + getItemName()); break;
      case ikDirectory     : System.out.println("Directory     : " + getItemName()); break;
      case ikDirectoryRoot : System.out.println("DirectoryRoot : " + getItemName()); break;
    }
  }
}
