/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.ideengine;

import java.util.*;
import java.awt.*;
import java.io.*;

import org.freebuilder.gui.idemenu.IdeMainMenu;
import org.freebuilder.gui.IdeTitleFrame;
import org.freebuilder.gui.editors.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.system.projectman.*;
import org.freebuilder.system.classes.ResMan;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.options.manager.OptionsMngr;
import org.freebuilder.system.debug.Debug;
import org.freebuilder.system.dpaths.*;


/** The purpose of class <code>Globals</code> is to hold some important for the ID
  * global variables. There will be only one instance of these classes.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class Globals {
  public  static Globals          GlobalsRef    = null;
  public  final static String     cDefaultProjectFileName = "JFBuilder.cfg";
  public  static String           FileSeparator           = System.getProperty("file.separator");
  public  static char             FileSeparatorChar       = File.separatorChar;
  public  static char             ZipFileSeparatorChar    = '/';
  public  static String           HomeDirectory           = PrepareHomeDirectory();
  public  static String           IconsDir                = "org" + FileSeparator + "freebuilder" + FileSeparator + "images" + FileSeparator;
  public  static String           spbIconsDir             = IconsDir + "SpeedButtons" + FileSeparator;

  private static String           ProjectFileName         = "";
  private static String           ProjectPath             = "";

  public  static String           JavaFileExt             = ".java";
  public  static String           PizzaFileExt            = ".pizza";
  public  static String           ClassFileExt            = ".class";
  public  static String           HTMLFileExt             = ".html";
  public  static String           HTMFileExt              = ".htm";
  public  static String           FreeBuilderIconName     = "Icon.gif";

  public  static Image            DefaultImage            = null;
  public  static ResMan           ResourceMngr            = null;
  public  static IdeMainMenu      MainMenu                = null;
  public  static IdeTitleFrame    IdeMainFrame            = null;
  public  static OptionsMngr      Options                 = null;
  public  static IdeEventsEngine  EventsEngine            = null;
  public  static IdeEngine        IEngine                 = null;
  public  static TextFilesManager TextFiles               = null;
  public  static ProjectManager   PManager                = null;
  public  static RootPathsColl    RootPaths               = null;
  public  static ProjectItems     PItems                  = null;   

  public  static boolean ShowLogoAtStartUp                = true;

  public Globals() {
    GlobalsRef = this;
  }

  public static String getProjectName() {
    return ProjectFileName;
  }

  public static String getCrntDir() {
    String CrntDir = System.getProperty("user.dir");
    if (CrntDir == null) return "";
    return CrntDir;
  }

  public static String getProjectTitleName() {
    String DefaultName = "Free Builder";
    
    if (ProjectFileName == null) return DefaultName;
    if (ProjectFileName.length() == 0) return DefaultName;
    return ProjectFileName;
  }

  public static void setProjectName(String AProjectName) {
    ProjectFileName = AProjectName;

    if (IdeMainFrame == null) return;
    IdeMainFrame.setTitle(getProjectTitleName());
    setProjectPath();
  }

  public static String AddFName2Path  (String APath, String AFileName) {
    if (APath     == null) return "";
    if (AFileName == null) return "";
    if (AFileName.length() == 0) return APath;
    if (APath.length() != 0) {
      if (!APath.endsWith (Globals.FileSeparator))
        APath = APath + Globals.FileSeparator;
    }

    APath = APath + AFileName;
    return APath;
  }

  public static String validateFileName(String FilePath) {
    String RetPath = "";
    String [] Ret = Misc.parsePath (FilePath, FileSeparatorChar);
    Vector Dirs   = new Vector();
    int i;
    int Count = Ret.length;

    for (i = 0; i < Count; i++) {
      if (Ret[i].compareTo("..") == 0) {
        if (Dirs.size() == 0)
          return FilePath;
        else {
          Dirs.removeElementAt (Dirs.size()-1);
          continue;
        }
      }
      if (Ret[i].compareTo(".") == 0)
        continue;
      Dirs.addElement (Ret[i]);
    }

    Count = Dirs.size();
    for (i = 0; i < Count; i++) {
      RetPath += Dirs.elementAt(i);
      if (i < Count -1)
        RetPath += FileSeparator;
    }
    if ((Dirs.size() == 1) && (RetPath.endsWith(":")))
      RetPath += FileSeparator;
    if(FilePath.startsWith(FileSeparator) && !RetPath.startsWith(FileSeparator))
      RetPath = FileSeparator+RetPath;
    return RetPath;
  }

  public static String ExtractFileName(String FilePath) {
    String FileN = "";
    int    Index = -1;
    if (FilePath == null) return "";

    Index = FilePath.lastIndexOf(FileSeparatorChar);
    try {
      FileN = FilePath.substring(Index + 1);
      return FileN;
    }
    catch(StringIndexOutOfBoundsException e) {
      return "";
    }
  }

  public static String getPath(String FileName) {
    String PathN = "";
    int    Index = -1;
    if (FileName == null) return "";

    Index = FileName.lastIndexOf(FileSeparatorChar);
    try {
      PathN = FileName.substring(0,Index);
      return PathN;
    }
    catch(StringIndexOutOfBoundsException e) {
      return "";
    }
  }

  public static String ExtractFileNameFromZip(String FilePath) {
    String FileN = "";
    int    Index = -1;
    if (FilePath == null) return "";

    Index = FilePath.lastIndexOf(ZipFileSeparatorChar);
    try {
      FileN = FilePath.substring(Index + 1);
      return FileN;
    }
    catch(StringIndexOutOfBoundsException e) {
      return "";
    }
  }
  
  public static void setProjectPath() {
    ProjectPath = getPath(getProjectName());
//    System.out.println("Project Name is : " + getProjectName());
//    System.out.println("Project Path is : " + ProjectPath);
  }

  public static String getProjectPath() {
    return ProjectPath;
  }

  public static void printHelp () {
    System.out.println ("FreeBuilder Options:");
    System.out.println ("   \\h or \\? - Shows this help screen.");
    System.out.println ("   \\nologo  - Prevents the FreeBuilder logo from loading at start up.");
  }

  public static void printUnknownOptionMessage (String Option) {
    System.out.println ("Unknown Option : [" + Option +"]");
    printHelp();
  }

  public static boolean checkArgs (String [] args) {
    int i;
    boolean Ret = true;
    for (i = 0; i < args.length; i++) {
      String Option = args[i].toLowerCase();
      if ((Option.compareTo ("/h") == 0) || (Option.compareTo ("/?") == 0)) {
        printHelp();
        Ret = false;
        continue;
      }

      if (Option.compareTo ("/nologo") == 0) {
        ShowLogoAtStartUp = false;
        continue;
      }
      
      printUnknownOptionMessage (Option);
    }
    return Ret;
  }

  private static String PrepareHomeDirectory() { // Added
    String Result = System.getProperty("user.home");
    if (Result.length() > 0) {
      if (! Result.endsWith(FileSeparator))
        Result = Result + FileSeparator;
    }
    return Result;
  }

  protected void finalize() {
    MainMenu      = null;
    IdeMainFrame  = null;
    EventsEngine  = null;
    Options       = null;
    ResourceMngr  = null;
    IEngine       = null;
  }

  // --------------------------------------------------------------------------------------------
  // Add Browse Collection Evnet Adapter
  // --------------------------------------------------------------------------------------------
  public static BrowseCItemEventAdapter AddBrowseCollAdapter(String OptionsName, int AEventNumber, int ACallMask, Object AMethodRef, String AMethodName) {
    BrowseCItemEventAdapter BrowseAdapter = null;
    try {
      BrowseAdapter = new BrowseCItemEventAdapter(OptionsName, AEventNumber, AMethodRef, AMethodName);
      EventsEngine.AddEventListener(BrowseAdapter);
    }
    catch (Exception e) {
      if (Debug.isDebug) Debug.Assert(e,null,"Hello from Globals");
    };
    return BrowseAdapter;
  }
  public static BrowseCItemEventAdapter AddDoBrowseCollAdapter(String OptionsName, int AEventNumber, Object AMethodRef, String AMethodName) {
    return AddBrowseCollAdapter(OptionsName, AEventNumber, IdeEventListenerI.CALL_MASK, AMethodRef, AMethodName);
  }

  public static BrowseCItemEventAdapter AddDoBeforeBrowseCollAdapter(String OptionsName, int AEventNumber, Object AMethodRef, String AMethodName) {
    return AddBrowseCollAdapter(OptionsName, AEventNumber, IdeEventListenerI.BEFORE_CALL_MASK, AMethodRef, AMethodName);
  }
  // --------------------------------------------------------------------------------------------

  // --------------------------------------------------------------------------------------------
  // Add Project Manager Evnet Adapter
  // --------------------------------------------------------------------------------------------
  public static ProjectManEventAdapter AddProjectManEAdapter(int AEventNumber, int ACallMask, Object AMethodRef, String AMethodName) {
    ProjectManEventAdapter PrManEAdapter = null;
    try {
      PrManEAdapter = new ProjectManEventAdapter(AEventNumber, ACallMask, AMethodRef, AMethodName);
      EventsEngine.AddEventListener(PrManEAdapter);
    }
    catch (Exception e) {
      if (Debug.isDebug) Debug.Assert(e,null," On Add Project Manager Event Adapter");
    };
    return PrManEAdapter;
  }

  public static ProjectManEventAdapter AddDoBeforeProjectManEAdapter(int AEventNumber, Object AMethodRef, String AMethodName) {
    return AddProjectManEAdapter(AEventNumber, IdeEventListenerI.BEFORE_CALL_MASK, AMethodRef, AMethodName);
  }

  public static ProjectManEventAdapter AddDoProjectManEAdapter(int AEventNumber, Object AMethodRef, String AMethodName) {
    return AddProjectManEAdapter(AEventNumber, IdeEventListenerI.CALL_MASK, AMethodRef, AMethodName);
  }

  public static ProjectManEventAdapter AddDoAfterProjectManEAdapter(int AEventNumber, Object AMethodRef, String AMethodName) {
    return AddProjectManEAdapter(AEventNumber, IdeEventListenerI.AFTER_CALL_MASK, AMethodRef, AMethodName);
  }
  // --------------------------------------------------------------------------------------------

}

