/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.options.opened;

import java.util.EventObject;
import java.lang.*;
import java.io.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.ideengine.Globals;

/** This class is responsible for supportin "The last Opened" files, projects 
  * You shold use only OnOpenFile & OnCloseFile methods from this class
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97
  */
public class StrItems extends StringList implements OptionsSuperI {
  final public  static int cMaxSize    = 15; // Only last 15th files will be membered
        private String     OptionsName = ""; // Options will be Referenced by a name.

  public StrItems(String AOptionsName) {
    OptionsName   = AOptionsName;
  }

  public OptionsSuperI Clone() {
    return (OptionsSuperI)clone();
  }

  /** clone only the strings !!!! */
  public synchronized Object clone() { // Will clone only the strings !!!!
    StrItems StrL = (StrItems)super.clone();
    StrL.OptionsName = OptionsName;
    return StrL;
  }

  public OptionsEvent PrepareEvent(int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }

  /** Compares the strings of both collections */
  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    boolean Result = ! Equals((Strings)TheOtherOne);
    return  Result;
  }

  /** Clears the collection */
  public void setDefaults() {
    Clear();
  }

  public String getName() {
    return OptionsName;
  }

  /** Adds this String and make it first. IF more than 20 strings are in collection the
    * ones after 20 are deleted. */
  public int OnOpenFile(final String S) {
    int Index = IndexOf(S);
    int Count;

    if (Index > 0) Move(Index,0);
    if (Index < 0) Insert(0,S,null);

    Count = getCount();

    if (Count > cMaxSize)
      Delete(Count - 1);

    return 0;
  }

  /** Does nothing till now. It is overwritten in subclasses */
  public void OnCloseFile() {}

  /** for testing */
  public void PrintItems() {
    String S1 = null;
    for(int Cntr = 0; Cntr < getCount(); Cntr ++) {
      S1 = getString(Cntr);
      if (S1 != null) System.out.println(S1);
    }
  }

}
