/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events.engine;

import java.util.EventObject;

/** The class <code>IdeSuperEvent</code>
  * This is the super class for all the events which will be Dispatched via IdeEventsEngin
  * Every new Event have to derive from EventObject, because every event has a source (Sender)
  * This is the super class for all the events which will be Dispatched via IdeEventsEngin
  * Every new Event have to derive from IdeSuperEvent.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */
  
public interface IdeSuperEventI {
  /** Get the actual event capsulated in this event */
  public    EventObject getEvent();
  /** Find which is the sender to the event */
  public    Object      getEventSender();

  /** @return 1 - for BeforeAction, 2 - OnAction, 3 - AfterAction */
  public    int         getEventPass();

  /** This function is called only by EventEngine object */
  public    void        setEventPass(int AEventPass);

  /** @return true if the event is handled by a listener */
  public    boolean     isHandled();

  /** This function is called only by EventEngine object */
  void        SetHandled();
}

