/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions.abstr;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ideoptions.*;
/**
  This class is a simple extender of ItemMan.
  Implements the functions for adding, removeing and moving
  the Beans within this Page.
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/

public class PalettePage extends ItemMan implements SimpleItem, NamedIconsCollection {

  /** The name of this Page. */
  private String Name;

  /** The PaletteMan object, that owns this page. */
  private PaletteOptions Owner;

  /** Initializes the object. */
  public PalettePage (PaletteOptions Owner) {
    super ();
    this.Owner = Owner;
  }

  /** Returns the name of this page. */
  public String getName () {
    return Name;
  }

  /** Returns the name of this page. */
  public String toString () {
    return Name;
  }

  /** Sets the name of this page. */
  public void setName (String NewName) {
    Name = NewName;
  }

  /** Returns the number of Beans, stored in this page. */
  public int getBeansCount () {
    return getItemsCount();
  }

  /** Adds a new Bean to this page. Duplicate Bans are allowed. */
  public void addBean (ABean NewBean) {
    addItem(NewBean);
  }

  /**
    Returns the Bean at the specified position.
    If the <code>BeanNo</code> is an invalid position,
    returns null.
  */
  public ABean getBean (int BeanNo) {
    return (ABean) getItem (BeanNo);
  }

  /**
    Returns the first occurance of the Bean with the specified
    name. If no Bean with the specified name exists, returns null.
  */
  public ABean getBean (String BeanName) {
    return (ABean) getItem (BeanName);
  }

  /**
    Removes the Bean at the specified position.
    If the <code>BeanNo</code> is an invalid position,
    does nothing.
  */
  public void removeBean (int BeanNo) {
    removeItem (BeanNo);
  }

  /**
    Removes the first occurance of the Bean with the specified
    name. If no such Bean exists, does nothing.
  */
  public void removeBean (String BeanName) {
    removeItem (BeanName);
  }

  /** Removes the specified Bean, if it exists in this page. */
  public void removeBean (ABean B) {
    removeItem (B);
  }

  /**
    Moves the Bean from the <code>SourcePos</code> to <code>DestPos</code>.
    If either of the arguments is an invalid posistion, does nothing.
  */
  public void moveBean (int SourcePos, int DestPos) {
    moveItem (SourcePos, DestPos);
  }

  /** Removes this page from the Owner's data. */
  public void remove () {
    Owner.removePage (this);
  }

  /**
    Returns the bean at the specified position on null,
    if the position is invalid.
  */
  public NamedIcon getNamedIcon (int AtPos) {
    return getBean (AtPos);
  }

  /** Returns the number of the stored beans */
  public int getCount () {
    return getBeansCount();
  }

  public void removeAllBeans () {
    super.removeAll();
  }

  public PalettePage clone (PaletteOptions NewOwner) {
    int i;
    PalettePage TheClone = new PalettePage (NewOwner);
    TheClone.setName (getName());
    for (i = 0; i < getBeansCount(); i++)
      TheClone.addBean (getBean(i).clone(TheClone));
    return TheClone;
  }

  public boolean equals (PalettePage AnotherPP) {
    int BeanCounter;
    int i;

    if ((BeanCounter = getBeansCount()) != AnotherPP.getBeansCount())
      return false;
    for (i = 0; i < BeanCounter; i++)
      if (!getBean(i).equals(AnotherPP.getBean(i)))
       return false;
    return true;
  }
}
