/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions;

import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.projectman.*;
import org.freebuilder.gui.config.*;
import java.util.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class VMOptions implements OptionsSuperI, Cloneable {
  public static final String VMOptionsName = "VMOptions";
  public static final int VERIFY_ALL       = 0;
  public static final int VERIFY_REMOTE    = 1;
  public static final int VERIFY_NONE      = 2;

  public static final int PROFILE_NONE     = 0;
  public static final int PROFILE_DEF      = 1;
  public static final int PROFILE_HERE     = 2;

  private String Params;

  private boolean DefaultNativeStack;
  private boolean DefaultJavaStack;
  private boolean DefaultInitialHeap;
  private boolean DefaultJavaHeap;


  private boolean Verbose;
  private boolean Debug;
  private boolean NoAsync;
  private boolean VerboseGC;
  private boolean NoClassGC;
  private int VerifyFlags;
  private int ProfileFlags;
  private String UserProfile;

  private String NativeStack;
  private String JavaStack;
  private String InitialHeap;
  private String JavaHeap;


  public String[] getOptions () {
    Vector Options = new Vector();
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    PathsOptions   POptions  = (PathsOptions)   (AOptions.getOptions(PathsOptions.PathsOptionsName));
    ProjectOptions PrOptions = (ProjectOptions) (AOptions.getOptions(ProjectOptions.cDefaultName));
    String ClassPathStr = "";
    String OutRootPath;
    Options.addElement ("java.exe");

    OutRootPath = POptions.getClassOutPath();

    Options.addElement ("-classpath");
    ClassPathStr = PathEditorDialog.getPath (POptions.getClassPath());
    if (ClassPathStr.length() > 0)
      ClassPathStr += ";";
    ClassPathStr += OutRootPath;
    Options.addElement (ClassPathStr);

    if (isVerbose())
      Options.addElement ("-verbose");
    if (isDebug())
      Options.addElement ("-debug");
    if (isNoAsync())
      Options.addElement ("-noasyncgc");
    if (isVerboseGC())
      Options.addElement ("-verbosegc");

    if (!isDefaultNativeStack())
      Options.addElement ("-ss" + getNativeStack());
    if (!isDefaultJavaStack())
      Options.addElement ("-oss"+ getJavaStack());
    if (!isDefaultInitialHeap())
      Options.addElement ("-ms" + getInitialHeap());
    if (!isDefaultJavaHeap())
      Options.addElement ("-mx" + getJavaHeap());

    switch (getProfileFlags()) {
      case VMOptions.PROFILE_NONE:
      break;
      case VMOptions.PROFILE_DEF:
        Options.addElement ("-prof");
      break;
      case VMOptions.PROFILE_HERE:
        Options.addElement ("-prof:" + getUserProfile());
      break;
    }

    switch (getVerifyFlags()) {
      case VMOptions.VERIFY_ALL:
        Options.addElement ("-verify");
      break;
      case VMOptions.VERIFY_REMOTE:
        Options.addElement ("-verifyremote");
      break;
      case VMOptions.VERIFY_NONE:
        Options.addElement ("-noverify");
      break;
    }

//    Options.addElement (PrOptions.getRunnable());
//    Options.addElement (getParams());

    String [] RetOptions = new String[Options.size()];
    Options.copyInto (RetOptions);
    return RetOptions;
  }

  public String getDebugOptions () {
    int i;
    String [] Opts = getOptions();
    String TheOpts = "";
    for (i = 1; i < Opts.length; i++)
      TheOpts += Opts[i] + " ";
    return TheOpts;
  }

  public boolean isDefaultNativeStack () {
    return DefaultNativeStack;
  }
  public void setDefaultNativeStack (boolean NewDefaults) {
    DefaultNativeStack = NewDefaults;
  }

  public boolean isDefaultJavaStack () {
    return DefaultJavaStack;
  }
  public void setDefaultJavaStack (boolean NewDefaults) {
    DefaultJavaStack = NewDefaults;
  }

  public boolean isDefaultInitialHeap () {
    return DefaultInitialHeap;
  }
  public void setDefaultInitialHeap (boolean NewDefaults) {
    DefaultInitialHeap = NewDefaults;
  }

  public boolean isDefaultJavaHeap () {
    return DefaultJavaHeap;
  }
  public void setDefaultJavaHeap (boolean NewDefaults) {
    DefaultJavaHeap = NewDefaults;
  }

  public void setUserProfile (String NewUserProfile) {
    UserProfile = NewUserProfile;
  }
  public String getUserProfile () {
    return UserProfile;
  }

  public int getProfileFlags () {
    return ProfileFlags;
  }
  public void setProfileFlags (int NewFlags) {
    if ((NewFlags == PROFILE_NONE) ||
        (NewFlags == PROFILE_DEF)  ||
        (NewFlags == PROFILE_HERE))
      ProfileFlags = NewFlags;
  }

  public int getVerifyFlags () {
    return VerifyFlags;
  }
  public void setVerifyFlags (int NewFlags) {
    if ((NewFlags == VERIFY_ALL)    ||
        (NewFlags == VERIFY_REMOTE) ||
        (NewFlags == VERIFY_NONE))
      VerifyFlags = NewFlags;
  }

  public boolean isVerbose () {
    return Verbose;
  }
  public void setVerbose (boolean Verbose) {
    this.Verbose = Verbose;
  }

  public boolean isDebug () {
    return Debug;
  }
  public void setDebug (boolean Debug) {
    this.Debug = Debug;
  }

  public boolean isNoAsync () {
    return NoAsync;
  }
  public void setNoAsync (boolean NoAsync) {
    this.NoAsync = NoAsync;
  }

  public boolean isVerboseGC () {
    return VerboseGC;
  }
  public void setVerboseGC (boolean VerboseGC) {
    this.VerboseGC = VerboseGC;
  }

  public boolean isNoClassGC () {
    return NoClassGC;
  }
  public void setNoClassGC (boolean NoClassGC) {
    this.NoClassGC = NoClassGC;
  }

  public String getParams () {
    return Params;
  }
  public void setParams (String NewParams) {
    Params = NewParams;
  }

  public String getNativeStack () {
    return NativeStack;
  }
  public void setNativeStack (String NewNativeStackSize) {
    NativeStack = NewNativeStackSize;
  }

  public String getJavaStack () {
    return JavaStack;
  }
  public void setJavaStack (String NewJavaStackSize) {
    JavaStack = NewJavaStackSize;
  }

  public String getInitialHeap () {
    return InitialHeap;
  }
  public void setInitialHeap (String NewInitialHeapSize) {
    InitialHeap = NewInitialHeapSize;
  }

  public String getJavaHeap () {
    return JavaHeap;
  }
  public void setJavaHeap (String NewJavaHeapSize) {
    JavaHeap = NewJavaHeapSize;
  }

// ================ OptionsSuperI implementation ================

  public OptionsSuperI Clone () throws CloneNotSupportedException {
    VMOptions TheClone = (VMOptions) (this.clone());
    TheClone.setParams      (new String (getParams()));
    TheClone.setUserProfile (new String (getUserProfile()));
    return TheClone;
  }

  public void setDefaults () {
    setUserProfile  (".\\java.prof");
    setProfileFlags (PROFILE_NONE);
    setVerifyFlags  (VERIFY_NONE);

    setDefaultNativeStack      (true);
    setDefaultJavaStack        (true);
    setDefaultInitialHeap      (true);
    setDefaultJavaHeap         (true);

    setVerbose      (false);
    setDebug        (false);
    setNoAsync      (false);
    setVerboseGC    (false);
    setNoClassGC    (false);
    setParams       ("");
    setNativeStack  ("");
    setJavaStack    ("");
    setInitialHeap  ("");
    setJavaHeap     ("");
  }

  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    VMOptions OtherOptions = (VMOptions) TheOtherOne;

    if (OtherOptions.getUserProfile().compareTo (getUserProfile()) != 0)
      return true;
    if (OtherOptions.getProfileFlags() != getProfileFlags())
      return true;
    if (OtherOptions.getVerifyFlags()  != getVerifyFlags())
      return true;
    if (OtherOptions.isVerbose()       != isVerbose())
      return true;
    if (OtherOptions.isDebug()         != isDebug())
      return true;
    if (OtherOptions.isNoAsync()       != isNoAsync())
      return true;
    if (OtherOptions.isVerboseGC()     != isVerboseGC())
      return true;
    if (OtherOptions.isNoClassGC()     != isNoClassGC())
      return true;
    if (OtherOptions.getParams().compareTo (getParams()) != 0)
      return true;
    if (OtherOptions.getNativeStack()  != getNativeStack())
      return true;
    if (OtherOptions.getJavaStack()    != getJavaStack())
      return true;
    if (OtherOptions.getInitialHeap()  != getInitialHeap())
      return true;
    if (OtherOptions.getJavaHeap()     != getJavaHeap())
      return true;
    if (OtherOptions.isDefaultNativeStack ()  != isDefaultNativeStack ())
      return true;
    if (OtherOptions.isDefaultJavaStack ()    != isDefaultJavaStack ())
      return true;
    if (OtherOptions.isDefaultInitialHeap ()  != isDefaultInitialHeap())
      return true;
    if (OtherOptions.isDefaultJavaHeap ()     != isDefaultJavaHeap ())
      return true;

    return false;
  }

  public String getName() {
    return VMOptionsName;
  }

  public OptionsEvent PrepareEvent(int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }
}

